/*
 * Decompiled with CFR 0.152.
 */
package net.sf.accolorhelper.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import net.sf.accolorhelper.ui.CellMouseAdapter;
import net.sf.accolorhelper.ui.ColorSet;

public class ColorOverviewComponent
extends JComponent {
    private static final int NUMBER_OF_ROWS = 9;
    private static final int BASE_ROW_INDEX = 0;
    private static final int PROTANOMALY_ROW_INDEX = 1;
    private static final int DEUTERANOMALY_ROW_INDEX = 2;
    private static final int TRITANOMALY_ROW_INDEX = 3;
    private static final int ATYPICAL_MONOCHROMATIC_ROW_INDEX = 4;
    private static final int PROTANOPIA_ROW_INDEX = 5;
    private static final int DEUTERANOPIA_ROW_INDEX = 6;
    private static final int TRITANOPIA_ROW_INDEX = 7;
    private static final int TYPICAL_MONOCHROMATIC_ROW_INDEX = 8;
    private static final String[] LABEL_KEYS = new String[]{"normal", "protanomaly", "deuteranomaly", "tritanomaly", "atypicalmonochromat", "protanopia", "deuteranopia", "tritanopia", "typicalmonochromat"};
    private static final long serialVersionUID = 1L;
    private String[] aLabels = new String[9];
    private Color[] aColors;
    private Color[] aProtanomalyColors;
    private Color[] aDeuteranomalyColors;
    private Color[] aTritanomalyColors;
    private Color[] aAtypicalMonochromaticColors;
    private Color[] aProtanopiaColors;
    private Color[] aDeuteranopiaColors;
    private Color[] aTritanopiaColors;
    private Color[] aTypicalMonochromaticColors;
    private boolean[] aSelection;
    private boolean[][] aChartSelection;

    public ColorOverviewComponent(Color[] pColors, ColorSet pColorSet) {
        ResourceBundle lResources = ResourceBundle.getBundle(ColorOverviewComponent.class.getName());
        for (int lRowIndex = 0; lRowIndex < 9; ++lRowIndex) {
            this.aLabels[lRowIndex] = lResources.getString(LABEL_KEYS[lRowIndex]);
        }
        this.aColors = pColors;
        this.aProtanomalyColors = pColorSet.aProtanomalyColors;
        this.aDeuteranomalyColors = pColorSet.aDeuteranomalyColors;
        this.aTritanomalyColors = pColorSet.aTritanomalyColors;
        this.aAtypicalMonochromaticColors = pColorSet.aAtypicalMonochromaticColors;
        this.aProtanopiaColors = pColorSet.aProtanopiaColors;
        this.aDeuteranopiaColors = pColorSet.aDeuteranopiaColors;
        this.aTritanopiaColors = pColorSet.aTritanopiaColors;
        this.aTypicalMonochromaticColors = pColorSet.aTypicalMonochromaticColors;
        this.aChartSelection = pColorSet.aSelection;
        this.aSelection = new boolean[pColors.length];
        this.addMouseListener(new CellMouseAdapter(){

            public void mouseClicked(MouseEvent pEvent) {
                int lLabelsWidth = ColorOverviewComponent.this.getLabelsWidth(ColorOverviewComponent.this.getGraphics());
                int lXAdustedForLabels = pEvent.getX() - lLabelsWidth - 5;
                if (this.isInCell(lXAdustedForLabels, pEvent.getY())) {
                    int lHorizontalCellIndex = this.getCellIndex(lXAdustedForLabels);
                    int lVerticalCellIndex = this.getCellIndex(pEvent.getY());
                    if (lHorizontalCellIndex < ColorOverviewComponent.this.aColors.length && lVerticalCellIndex < 9) {
                        ((ColorOverviewComponent)ColorOverviewComponent.this).aSelection[lHorizontalCellIndex] = !ColorOverviewComponent.this.aSelection[lHorizontalCellIndex];
                        for (int lColorIndex = 0; lColorIndex < ColorOverviewComponent.this.aColors.length; ++lColorIndex) {
                            ((ColorOverviewComponent)ColorOverviewComponent.this).aChartSelection[lHorizontalCellIndex][lColorIndex] = ColorOverviewComponent.this.aSelection[lHorizontalCellIndex];
                            ((ColorOverviewComponent)ColorOverviewComponent.this).aChartSelection[lColorIndex][lHorizontalCellIndex] = ColorOverviewComponent.this.aSelection[lHorizontalCellIndex];
                            ColorOverviewComponent.this.repaint();
                        }
                    }
                }
            }
        });
    }

    public void setColors(Color[] pColors, ColorSet pColorSet) {
        this.aColors = pColors;
        this.aProtanomalyColors = pColorSet.aProtanomalyColors;
        this.aDeuteranomalyColors = pColorSet.aDeuteranomalyColors;
        this.aTritanomalyColors = pColorSet.aTritanomalyColors;
        this.aAtypicalMonochromaticColors = pColorSet.aAtypicalMonochromaticColors;
        this.aProtanopiaColors = pColorSet.aProtanopiaColors;
        this.aDeuteranopiaColors = pColorSet.aDeuteranopiaColors;
        this.aTritanopiaColors = pColorSet.aTritanopiaColors;
        this.aTypicalMonochromaticColors = pColorSet.aTypicalMonochromaticColors;
        this.aChartSelection = pColorSet.aSelection;
        this.aSelection = new boolean[pColors.length];
        this.revalidate();
        this.repaint();
    }

    public Dimension getMinimumSize() {
        int lLabelsWidth = this.getLabelsWidth(this.getGraphics());
        return new Dimension(lLabelsWidth + 45 * this.aColors.length + 15, 415);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics pGraphics) {
        Color lForegroundColor = this.getForeground();
        Color lBackgroundColor = this.getBackground();
        FontMetrics lFontMetrics = pGraphics.getFontMetrics();
        int lLabelsYOffset = 5;
        lLabelsYOffset += (40 - lFontMetrics.getHeight()) / 2;
        lLabelsYOffset += pGraphics.getFontMetrics().getAscent() - 1;
        int lLabelsWidth = this.getLabelsWidth(pGraphics);
        int lColorsOffset = lLabelsWidth + 10;
        for (int lRowIndex = 0; lRowIndex < 9; ++lRowIndex) {
            pGraphics.setColor(lForegroundColor);
            String lLabel = this.aLabels[lRowIndex];
            pGraphics.drawString(lLabel, 5, lLabelsYOffset + lRowIndex * 45);
            for (int lColorIndex = 0; lColorIndex < this.aColors.length; ++lColorIndex) {
                if (this.aSelection[lColorIndex]) {
                    pGraphics.setColor(lForegroundColor);
                    pGraphics.fillRect(lColorsOffset + lColorIndex * 45, 5 + lRowIndex * 45, 40, 40);
                    pGraphics.setColor(lBackgroundColor);
                    pGraphics.drawRect(lColorsOffset + lColorIndex * 45 + 5 - 1, 5 + lRowIndex * 45 + 5 - 1, 31, 31);
                }
                switch (lRowIndex) {
                    case 0: {
                        pGraphics.setColor(this.aColors[lColorIndex]);
                        break;
                    }
                    case 1: {
                        pGraphics.setColor(this.aProtanomalyColors[lColorIndex]);
                        break;
                    }
                    case 2: {
                        pGraphics.setColor(this.aDeuteranomalyColors[lColorIndex]);
                        break;
                    }
                    case 3: {
                        pGraphics.setColor(this.aTritanomalyColors[lColorIndex]);
                        break;
                    }
                    case 4: {
                        pGraphics.setColor(this.aAtypicalMonochromaticColors[lColorIndex]);
                        break;
                    }
                    case 5: {
                        pGraphics.setColor(this.aProtanopiaColors[lColorIndex]);
                        break;
                    }
                    case 6: {
                        pGraphics.setColor(this.aDeuteranopiaColors[lColorIndex]);
                        break;
                    }
                    case 7: {
                        pGraphics.setColor(this.aTritanopiaColors[lColorIndex]);
                        break;
                    }
                    case 8: {
                        pGraphics.setColor(this.aTypicalMonochromaticColors[lColorIndex]);
                    }
                }
                pGraphics.fillRect(lColorsOffset + lColorIndex * 45 + 5, 5 + lRowIndex * 45 + 5, 30, 30);
            }
        }
    }

    private int getLabelsWidth(Graphics pGraphics) {
        FontMetrics lFontMetrics = pGraphics.getFontMetrics();
        int result = 0;
        for (int lRowIndex = 0; lRowIndex < 9; ++lRowIndex) {
            int lLabelWidth = (int)lFontMetrics.getStringBounds(this.aLabels[lRowIndex], pGraphics).getWidth();
            result = Math.max(result, lLabelWidth);
        }
        return result;
    }
}

