/*
 * Decompiled with CFR 0.152.
 */
package net.sf.accolorhelper.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.plaf.BorderUIResource;
import net.sf.accolorhelper.filter.ColorFilter;

public class FilteringImageComponent
extends JComponent {
    private static final long serialVersionUID = 1L;
    private ColorFilter aFilter;
    private int aWidth;
    private int aHeight;
    private Image aImage;

    public FilteringImageComponent(ColorFilter pFilter, int pWidth, int pHeight) {
        this.setBorder(BorderUIResource.getLoweredBevelBorderUIResource());
        this.aFilter = pFilter;
        this.aWidth = pWidth;
        this.aHeight = pHeight;
    }

    public void paint(Graphics pGraphics) {
        super.paint(pGraphics);
        if (this.aImage != null) {
            Insets lBorderInsets = this.getBorder().getBorderInsets(this);
            Graphics lImageGraphics = pGraphics.create(lBorderInsets.left + 1, lBorderInsets.top + 1, this.aWidth, this.aHeight);
            lImageGraphics.drawImage(this.aImage, 0, 0, null);
        }
    }

    public Dimension getMinimumSize() {
        Insets lBorderInsets = this.getBorder().getBorderInsets(this);
        return new Dimension(lBorderInsets.left + this.aWidth + lBorderInsets.right + 2, lBorderInsets.top + this.aHeight + lBorderInsets.bottom + 2);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void setImage(BufferedImage pSource) {
        this.aImage = this.aFilter.filter(pSource);
        this.repaint();
    }
}

