/*
 * Decompiled with CFR 0.152.
 */
package net.sf.accolorhelper.ui;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.sf.accolorhelper.ui.ColorComparisonComponent;
import net.sf.accolorhelper.ui.DeficiencyLevel;
import net.sf.accolorhelper.ui.SpecificDeficiencyLevelColorSet;

public class SpecificDeficiencyLevelComparisonComponent
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String ANOMALOUS_TRICHOMACY_RESOURCE_PREFIX = "anomaloustrichomacy";
    private static final String DICHROMACY_RESOURCE_PREFIX = "dichromacy";
    private static final String UNKNOWN_DEFICIENCY_RESOURCE_PREFIX = "unknown";
    private DeficiencyLevel aType;
    private ColorComparisonComponent aProtanComparisonComponent;
    private ColorComparisonComponent aDeutanComparisonComponent;
    private ColorComparisonComponent aTritanComparisonComponent;
    private ColorComparisonComponent aMonochromatComparisonComponent;
    private ResourceBundle aResources = ResourceBundle.getBundle(SpecificDeficiencyLevelComparisonComponent.class.getName());

    public SpecificDeficiencyLevelComparisonComponent(SpecificDeficiencyLevelColorSet pColorSet) {
        this.aType = pColorSet.aType;
        GridBagLayout lLayout = new GridBagLayout();
        this.setLayout(lLayout);
        JTabbedPane lOuterPane = new JTabbedPane(1, 0);
        this.aProtanComparisonComponent = new ColorComparisonComponent(pColorSet.aProtanColors, pColorSet.aSelection);
        lOuterPane.add(this.getTabLabel(this.aResources, pColorSet.aType, "protan"), this.aProtanComparisonComponent);
        this.aDeutanComparisonComponent = new ColorComparisonComponent(pColorSet.aDeutanColors, pColorSet.aSelection);
        lOuterPane.add(this.getTabLabel(this.aResources, pColorSet.aType, "deutan"), this.aDeutanComparisonComponent);
        this.aTritanComparisonComponent = new ColorComparisonComponent(pColorSet.aTritanColors, pColorSet.aSelection);
        lOuterPane.add(this.getTabLabel(this.aResources, pColorSet.aType, "tritan"), this.aTritanComparisonComponent);
        this.aMonochromatComparisonComponent = new ColorComparisonComponent(pColorSet.aMonochromatColors, pColorSet.aSelection);
        lOuterPane.add(this.getTabLabel(this.aResources, pColorSet.aType, "monochromat"), this.aMonochromatComparisonComponent);
        this.add(lOuterPane);
        GridBagConstraints lConstraints = new GridBagConstraints();
        lConstraints.insets = new Insets(10, 10, 10, 10);
        lConstraints.weightx = 1.0;
        lConstraints.weighty = 1.0;
        lConstraints.fill = 1;
        lLayout.setConstraints(lOuterPane, lConstraints);
    }

    public void setColors(SpecificDeficiencyLevelColorSet pColorSet) {
        this.aProtanComparisonComponent.setColors(pColorSet.aProtanColors, pColorSet.aSelection);
        this.aDeutanComparisonComponent.setColors(pColorSet.aDeutanColors, pColorSet.aSelection);
        this.aTritanComparisonComponent.setColors(pColorSet.aTritanColors, pColorSet.aSelection);
        this.aMonochromatComparisonComponent.setColors(pColorSet.aMonochromatColors, pColorSet.aSelection);
    }

    public Dimension getPreferredSize() {
        int lTabLabelsWdith;
        if (!this.isPreferredSizeSet() && (lTabLabelsWdith = this.getTabLabelsWdith(this.aResources, this.aType)) >= 0) {
            this.setPreferredSize(new Dimension((int)((double)lTabLabelsWdith * 1.2), lTabLabelsWdith / 2));
        }
        return super.getPreferredSize();
    }

    private String getResourcePrefix(DeficiencyLevel pDeficiencyType) {
        String result;
        switch (pDeficiencyType) {
            case WEAK: {
                result = ANOMALOUS_TRICHOMACY_RESOURCE_PREFIX;
                break;
            }
            case SEVERE: {
                result = DICHROMACY_RESOURCE_PREFIX;
                break;
            }
            default: {
                result = UNKNOWN_DEFICIENCY_RESOURCE_PREFIX;
            }
        }
        return result;
    }

    private String getTabLabel(ResourceBundle pResources, DeficiencyLevel pDeficiencyType, String pTabResourceKey) {
        return pResources.getString("tab." + this.getResourcePrefix(pDeficiencyType) + "." + pTabResourceKey);
    }

    private int getTabLabelsWdith(ResourceBundle pResources, DeficiencyLevel pType) {
        int result;
        StringBuffer lConcatenatedLabels = new StringBuffer();
        lConcatenatedLabels.append(this.getTabLabel(pResources, pType, "protan"));
        lConcatenatedLabels.append(this.getTabLabel(pResources, pType, "deutan"));
        lConcatenatedLabels.append(this.getTabLabel(pResources, pType, "tritan"));
        lConcatenatedLabels.append(this.getTabLabel(pResources, pType, "monochromat"));
        Graphics lGraphics = this.getGraphics();
        if (lGraphics != null) {
            FontMetrics lFontMetrics = lGraphics.getFontMetrics();
            result = (int)lFontMetrics.getStringBounds(lConcatenatedLabels.toString(), this.getGraphics()).getWidth();
        } else {
            result = -1;
        }
        return result;
    }
}

