/*
 * Decompiled with CFR 0.152.
 */
package com.casaerwin.brutus;

import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.hsqldb.jdbcDriver;

class DBMInit {
    private static String fileName = "BrutusInit.ddl";
    private static String dbName = "BrutusDB";
    private static String uID = "sa";
    private static String passWord = "";
    private static String uRL = "jdbc:hsqldb:" + dbName;
    private static String backup = dbName + ".backup";
    private static String data = dbName + ".data";
    private static String properties = dbName + ".properties";
    private static String script = dbName + ".script";

    DBMInit() {
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("USAGE: java DBMInit arg\n   where arg is either \"init\" or the name of an input file\ninit creates new database files which destroys all current data\ninput file is the name of a file which contains ddl statements\n");
            return;
        }
        if (stringArray[0].equals("init")) {
            try {
                new File(backup).delete();
                new File(data).delete();
                new File(properties).delete();
                new File(script).delete();
            }
            catch (Exception exception) {}
        } else {
            fileName = stringArray[0];
        }
        try {
            DriverManager.registerDriver(new jdbcDriver());
            DBMInit.initializeBrutusDB(uRL, uID, passWord);
        }
        catch (Exception exception) {
            DBMInit.print("DBMInit error: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    static void initializeBrutusDB(String string, String string2, String string3) throws Exception {
        String string4;
        Statement statement = null;
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(string, string2, string3);
            statement = connection.createStatement();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            DBMInit.print("DBMInit init error: " + exception.getMessage());
        }
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(fileName));
        String string5 = "";
        while ((string4 = lineNumberReader.readLine()) != null) {
            if (string4.startsWith("-")) continue;
            if (string4.startsWith(" ")) {
                string5 = string5 + string4;
                continue;
            }
            DBMInit.duit(statement, string5);
            string5 = string4;
        }
        connection.close();
    }

    static void duit(Statement statement, String string) {
        if (!string.equals("")) {
            try {
                statement.execute(string);
            }
            catch (SQLException sQLException) {
                DBMInit.print("SQL Error - " + sQLException.getMessage());
            }
        }
    }

    private static void print(String string) {
        System.out.println(string);
    }
}

