/*
 * Decompiled with CFR 0.152.
 */
package com.lemckes.cellarboss;

import com.lemckes.cellarboss.CreateDatabaseDialog;
import com.lemckes.cellarboss.IdNameManagerView;
import com.lemckes.cellarboss.VarietiesManagerView;
import com.lemckes.cellarboss.WineList;
import com.lemckes.cellarboss.WineListView;
import com.lemckes.cellarboss.WineriesManagerView;
import com.lemckes.cellarboss.util.DatabaseConnection;
import com.lemckes.cellarboss.util.DbUtils;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.SplashScreen;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;

public class CellarBoss
extends JFrame {
    private static SplashScreen splash;
    private static WineList wineList;
    private Properties userProps;
    private CreateDatabaseDialog createDialog;
    private boolean alreadyClosed;
    private static JFrame thisFrame;
    private static Logger logger;
    private JMenuItem aboutMenuItem;
    private JMenuItem contentsMenuItem;
    private JMenuItem drinkNextMenuItem;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuBar menuBar;
    private JMenu reportMenu;
    private JMenuItem showMenuItem;
    private JTabbedPane tabbedPane;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellarBoss() {
        block26: {
            this.alreadyClosed = false;
            thisFrame = this;
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (!CellarBoss.this.alreadyClosed) {
                        DatabaseConnection.closeConnection();
                    }
                }
            });
            String userConfig = System.getProperty("user.home");
            userConfig = userConfig + System.getProperty("file.separator");
            userConfig = userConfig + "CellarBoss.config";
            this.userProps = new Properties();
            try {
                FileReader reader = new FileReader(userConfig);
                this.userProps.load(reader);
            }
            catch (FileNotFoundException ex) {
                this.createDialog = new CreateDatabaseDialog(null, true);
                if (splash != null) {
                    splash.close();
                    splash = null;
                }
                this.createDialog.setLocationRelativeTo(null);
                this.createDialog.setVisible(true);
                if (this.createDialog.getReturnStatus() == 1) {
                    OutputStreamWriter writer = null;
                    try {
                        this.userProps.setProperty("derby.system.home", this.createDialog.getSelectedPath());
                        writer = new FileWriter(userConfig);
                        this.userProps.store(writer, "CellarBoss database config");
                        DatabaseConnection.setProperties(this.userProps);
                        try {
                            DbUtils.createDatabaseTables(DatabaseConnection.getConnection());
                        }
                        catch (SQLException ex1) {
                            JOptionPane.showMessageDialog(this, "Failed to create the database tables : " + ex.getMessage(), "Create Failed", 0);
                            DbUtils.logSQLException(this.getClass(), "Create Database Failed", ex1);
                            System.exit(1);
                        }
                    }
                    catch (IOException ex1) {
                        logger.log(Level.SEVERE, null, ex1);
                        System.exit(1);
                        break block26;
                    }
                    finally {
                        try {
                            writer.close();
                        }
                        catch (IOException ex1) {
                            logger.log(Level.SEVERE, null, ex1);
                        }
                    }
                }
                logger.log(Level.INFO, "Startup cancelled.");
                System.exit(0);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
                System.exit(1);
            }
        }
        try {
            DatabaseConnection.setProperties(this.userProps);
            int dbVersion = DbUtils.getDatabaseVersion(DatabaseConnection.getConnection());
            if (dbVersion < 3) {
                int resp = JOptionPane.showConfirmDialog(this, "<html>About to update the database<br> from Version " + dbVersion + " to Version " + 3 + "</html>", "Update Database", 2, 1);
                if (resp == 0) {
                    DbUtils.updateSchema(DatabaseConnection.getConnection(), dbVersion, 3);
                } else {
                    System.exit(0);
                }
            } else if (dbVersion > 3) {
                JOptionPane.showMessageDialog(this, "<html>You seem to be using a new database (<b>Version " + dbVersion + "</b>)<br>" + "with an older version of the program (<b>Version " + 3 + "</b>).<br><br>" + "Please download the latest version of CellarBoss from<br><br>" + "<tt>http://cellarboss.sourceforge.net</tt>", "Version Mismatch", 0);
                System.exit(1);
            }
            wineList = new WineList(this.userProps);
            wineList.readDatabase();
        }
        catch (SQLException ex) {
            ArrayList<String> messages = DbUtils.getMessages(ex);
            StringBuilder sbDialog = new StringBuilder();
            for (String m : messages) {
                sbDialog.append(m);
                sbDialog.append("<br />");
            }
            JOptionPane.showMessageDialog(this, "<html>Failed to read the database<br>" + sbDialog.toString() + "</html>", "Read Failed", 0);
            DbUtils.logSQLException(this.getClass(), "Read Failed", ex);
            System.exit(1);
        }
        this.initComponents();
        this.tabbedPane.add("Bottles", new WineListView(wineList));
        this.tabbedPane.add("Wineries", new WineriesManagerView(wineList.getWineries(), wineList.getRegions()));
        this.tabbedPane.add("Regions", new IdNameManagerView(wineList.getRegions()));
        this.tabbedPane.add("Varieties", new VarietiesManagerView(wineList.getVarieties(), wineList.getStyles()));
        this.tabbedPane.add("Styles", new IdNameManagerView(wineList.getStyles()));
        this.tabbedPane.add("Locations", new IdNameManagerView(wineList.getLocations()));
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public static void repack() {
        thisFrame.pack();
    }

    public static WineList getWineList() {
        return wineList;
    }

    private void generateReport(final String reportFileName) {
        SwingWorker<JasperPrint, Object> w = new SwingWorker<JasperPrint, Object>(){

            @Override
            protected JasperPrint doInBackground() throws Exception {
                CellarBoss.this.reportMenu.setEnabled(false);
                InputStream is = this.getClass().getClassLoader().getResourceAsStream(reportFileName);
                JasperPrint print = JasperFillManager.fillReport(is, null, DatabaseConnection.getConnection());
                return print;
            }

            @Override
            protected void done() {
                CellarBoss.this.reportMenu.setEnabled(true);
                try {
                    JasperViewer.viewReport((JasperPrint)this.get(), false);
                }
                catch (InterruptedException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        };
        w.execute();
    }

    private void closeApplication() {
        DatabaseConnection.closeConnection();
        this.alreadyClosed = true;
        System.exit(0);
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exitMenuItem = new JMenuItem();
        this.reportMenu = new JMenu();
        this.showMenuItem = new JMenuItem();
        this.drinkNextMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("CellarBoss");
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.tabbedPane.getAccessibleContext().setAccessibleName("Bottles");
        this.fileMenu.setMnemonic('F');
        ResourceBundle bundle = ResourceBundle.getBundle("com/lemckes/cellarboss/Bundle");
        this.fileMenu.setText(bundle.getString("CellarBoss.menuBar.FileMenu.text"));
        this.exitMenuItem.setText(bundle.getString("CellarBoss.menuBar.FileMenu.exitMenuItem.text"));
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellarBoss.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.reportMenu.setMnemonic('R');
        this.reportMenu.setText(bundle.getString("CellarBoss.menuBar.reportMenu.text"));
        this.showMenuItem.setMnemonic('W');
        this.showMenuItem.setText(bundle.getString("CellarBoss.menuBar.reportMenu.showMenuItem.text"));
        this.showMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellarBoss.this.showMenuItemActionPerformed(evt);
            }
        });
        this.reportMenu.add(this.showMenuItem);
        this.drinkNextMenuItem.setMnemonic('D');
        this.drinkNextMenuItem.setText(bundle.getString("CellarBoss.menuBar.reportMenu.drinkNextMenuItem.text"));
        this.drinkNextMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellarBoss.this.drinkNextMenuItemActionPerformed(evt);
            }
        });
        this.reportMenu.add(this.drinkNextMenuItem);
        this.menuBar.add(this.reportMenu);
        this.helpMenu.setText(bundle.getString("CellarBoss.menuBar.helpMenu.text"));
        this.contentsMenuItem.setText(bundle.getString("CellarBoss.menuBar.helpMenu.contentsMenuItem.text"));
        this.helpMenu.add(this.contentsMenuItem);
        this.aboutMenuItem.setText(bundle.getString("CellarBoss.menuBar.helpMenu.aboutMenuItem.text"));
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.closeApplication();
    }

    private void showMenuItemActionPerformed(ActionEvent evt) {
        this.generateReport("wineReport.jasper");
    }

    private void drinkNextMenuItemActionPerformed(ActionEvent evt) {
        this.generateReport("drinkingReport.jasper");
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                splash = SplashScreen.getSplashScreen();
                try {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (!"Nimbus".equals(info.getName())) continue;
                        UIManager.setLookAndFeel(info.getClassName());
                        break;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                CellarBoss cm = new CellarBoss();
                if (splash != null) {
                    splash.close();
                }
                cm.setVisible(true);
            }
        });
    }

    static {
        logger = Logger.getLogger(CellarBoss.class.getName());
    }
}

