/*
 * Decompiled with CFR 0.152.
 */
package com.lemckes.cellarboss.util;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class TableColumnWidthSetter {
    public static void setColumnWidths(JTable table, Object[] longValues) {
        TableColumnWidthSetter.setColumnWidths(table, longValues, false);
    }

    public static void setColumnWidths(JTable table, Object[] longValues, boolean fillParent) {
        TableModel model = table.getModel();
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        int editorWidth = 0;
        int used = 0;
        int i = 0;
        Enumeration<TableColumn> columns = table.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            column = columns.nextElement();
            TableCellRenderer headerRenderer = column.getHeaderRenderer();
            if (headerRenderer == null) {
                headerRenderer = table.getTableHeader().getDefaultRenderer();
            }
            comp = headerRenderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, -1, 0);
            Dimension d = comp.getPreferredSize();
            headerWidth = d.width;
            if (longValues != null && i < longValues.length && longValues[i] != null) {
                TableCellRenderer cellRenderer = column.getCellRenderer();
                if (cellRenderer == null) {
                    cellRenderer = table.getDefaultRenderer(model.getColumnClass(i));
                }
                comp = cellRenderer.getTableCellRendererComponent(table, longValues[i], false, false, 0, i);
                cellWidth = comp.getPreferredSize().width;
            } else {
                cellWidth = 0;
            }
            if (longValues != null && i < longValues.length && longValues[i] != null) {
                TableCellEditor cellEditor = column.getCellEditor();
                if (cellEditor == null) {
                    cellEditor = table.getDefaultEditor(model.getColumnClass(i));
                }
                comp = cellEditor.getTableCellEditorComponent(table, longValues[i], false, 0, i);
                editorWidth = comp.getPreferredSize().width;
            } else {
                editorWidth = 0;
            }
            int fudgeFactor = 3;
            int colWidth = Math.max(Math.max(headerWidth, cellWidth), editorWidth) + fudgeFactor;
            column.setPreferredWidth(colWidth);
            column.setWidth(colWidth);
            used += column.getPreferredWidth();
            ++i;
        }
        if (fillParent && table.getParent() != null) {
            int insetwidth = table.getParent().getInsets().right + table.getParent().getInsets().left;
            int tot = (table.getColumnCount() + 1) * table.getIntercellSpacing().width + used + insetwidth;
            if (table.getParent().getWidth() > tot) {
                int sizeleft = table.getParent().getWidth() - tot + table.getColumnCount() + 1;
                for (i = 0; i < table.getColumnCount(); ++i) {
                    int give = sizeleft / (table.getColumnCount() - i);
                    sizeleft -= give;
                    TableColumn col = table.getColumnModel().getColumn(i);
                    col.setPreferredWidth(col.getPreferredWidth() + give);
                }
                if (table.getColumnCount() > 0) assert (sizeleft == 0) : sizeleft;
            }
        }
    }

    public static void setColumnWidths(JTable table, boolean fillParent) {
        TableModel model = table.getModel();
        Object[] longestVals = new Object[model.getColumnCount()];
        for (int col = 0; col < longestVals.length; ++col) {
            Object longest = null;
            int maxWidth = 0;
            for (int row = 0; row < table.getRowCount(); ++row) {
                Object val = model.getValueAt(row, col);
                Component renderComp = table.getDefaultRenderer(model.getColumnClass(col)).getTableCellRendererComponent(table, val, false, false, 0, col);
                int cellWidth = renderComp.getPreferredSize().width;
                Component editorComp = table.getDefaultEditor(model.getColumnClass(col)).getTableCellEditorComponent(table, val, false, 0, col);
                int editorWidth = editorComp.getPreferredSize().width;
                if ((cellWidth = Math.max(cellWidth, editorWidth)) <= maxWidth) continue;
                maxWidth = cellWidth;
                longest = val;
            }
            longestVals[col] = longest;
        }
        TableColumnWidthSetter.setColumnWidths(table, longestVals, fillParent);
    }
}

