/*
 * Decompiled with CFR 0.152.
 */
package panels;

import application.ClassroomScheduler;
import application.Schedule;
import application.ViewGraphSched;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import resources.Classroom;
import resources.Professor;

public class ViewCharts
extends JPanel
implements Observer {
    private JComboBox availableProfs;
    private JComboBox availableRooms;
    private ButtonGroup chartChoice;
    private JScrollPane chartScrollPane;
    private JPanel choicePanel;
    private JButton printAllSimilar;
    private JPanel printPanel;
    private JButton printThis;
    private JRadioButton profRadioButton;
    private JRadioButton roomRadioButton;
    private Schedule schedule = Schedule.getSchedule();
    private ViewGraphSched viewGraphSched = new ViewGraphSched(null);

    public ViewCharts() {
        this.initComponents();
        this.addListeners();
    }

    private void initComponents() {
        this.chartChoice = new ButtonGroup();
        this.choicePanel = new JPanel();
        this.profRadioButton = new JRadioButton();
        this.availableProfs = new JComboBox();
        this.roomRadioButton = new JRadioButton();
        this.availableRooms = new JComboBox();
        this.chartScrollPane = new JScrollPane();
        this.printPanel = new JPanel();
        this.printThis = new JButton();
        this.printAllSimilar = new JButton();
        this.setLayout(new GridBagLayout());
        this.choicePanel.setLayout(new GridBagLayout());
        this.choicePanel.setBorder(new CompoundBorder(new EtchedBorder(), new BevelBorder(0)));
        this.choicePanel.setMaximumSize(new Dimension(173, Integer.MAX_VALUE));
        this.profRadioButton.setSelected(true);
        this.profRadioButton.setToolTipText("View the schedule for a single classroom or a single professor");
        this.chartChoice.add(this.profRadioButton);
        this.profRadioButton.setActionCommand("professor");
        this.profRadioButton.setLabel("Professor");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 6, 6, 52);
        this.choicePanel.add((Component)this.profRadioButton, gridBagConstraints);
        this.availableProfs.setMaximumRowCount(20);
        this.availableProfs.setToolTipText("Pick the Prof  to display");
        this.availableProfs.setMaximumSize(new Dimension(40, Short.MAX_VALUE));
        this.availableProfs.setMinimumSize(new Dimension(40, 25));
        this.availableProfs.setPreferredSize(new Dimension(40, 25));
        this.availableProfs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewCharts.this.availableProfsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 96;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 25);
        this.choicePanel.add((Component)this.availableProfs, gridBagConstraints);
        this.roomRadioButton.setToolTipText("View the schedule for a single classroom or a single professor");
        this.chartChoice.add(this.roomRadioButton);
        this.roomRadioButton.setActionCommand("classroom");
        this.roomRadioButton.setLabel("Classroom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 47);
        this.choicePanel.add((Component)this.roomRadioButton, gridBagConstraints);
        this.availableRooms.setMaximumRowCount(20);
        this.availableRooms.setToolTipText("Pick the classroom to display.");
        this.availableRooms.setMaximumSize(new Dimension(40, Short.MAX_VALUE));
        this.availableRooms.setMinimumSize(new Dimension(40, 25));
        this.availableRooms.setPreferredSize(new Dimension(40, 25));
        this.availableRooms.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 96;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 12, 25);
        this.choicePanel.add((Component)this.availableRooms, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 25;
        gridBagConstraints.insets = new Insets(137, 20, 18, 9);
        this.add((Component)this.choicePanel, gridBagConstraints);
        this.chartScrollPane.setVerticalScrollBarPolicy(22);
        this.chartScrollPane.setPreferredSize(new Dimension(450, 700));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.ipady = 100;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 20, 18, 0);
        this.add((Component)this.chartScrollPane, gridBagConstraints);
        this.printPanel.setLayout(new GridBagLayout());
        this.printPanel.setBorder(new CompoundBorder(new EtchedBorder(), new BevelBorder(0)));
        this.printPanel.setMaximumSize(new Dimension(173, 85));
        this.printPanel.setMinimumSize(new Dimension(173, 85));
        this.printPanel.setPreferredSize(new Dimension(173, 85));
        this.printThis.setText("Print This View");
        this.printThis.setToolTipText("Send this page only to printer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.printPanel.add((Component)this.printThis, gridBagConstraints);
        this.printAllSimilar.setText("Print All Similar Views");
        this.printAllSimilar.setToolTipText("Prints all rooms, or all full-time profs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.printPanel.add((Component)this.printAllSimilar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 25;
        gridBagConstraints.insets = new Insets(0, 20, 0, 9);
        this.add((Component)this.printPanel, gridBagConstraints);
    }

    private void availableProfsActionPerformed(ActionEvent evt) {
    }

    public void update(Observable o, Object arg) {
        if (this.profRadioButton.isSelected()) {
            this.availableProfs.removeAllItems();
            this.availableProfs.setEnabled(true);
            this.availableRooms.setEnabled(false);
            Iterator it = this.schedule.getProfessors().iterator();
            while (it.hasNext()) {
                this.availableProfs.addItem(it.next());
            }
        } else {
            this.availableRooms.removeAllItems();
            this.availableProfs.setEnabled(false);
            this.availableRooms.setEnabled(true);
            this.availableRooms.setEnabled(false);
            Iterator it = this.schedule.getClassrooms().iterator();
            while (it.hasNext()) {
                this.availableRooms.addItem(it.next());
            }
        }
    }

    private void addListeners() {
        ShowIt listener = new ShowIt();
        this.profRadioButton.addActionListener(listener);
        this.roomRadioButton.addActionListener(listener);
        this.availableProfs.addActionListener(listener);
        this.availableRooms.addActionListener(listener);
        this.printThis.addActionListener(listener);
        this.printAllSimilar.addActionListener(listener);
        this.chartScrollPane.setPreferredSize(new Dimension(450, 700));
        this.chartScrollPane.setViewportView(this.viewGraphSched);
        this.chartScrollPane.revalidate();
    }

    private void printTheView(Pageable toPrint, boolean confirm) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPageable(toPrint);
        if (confirm) {
            if (printJob.printDialog()) {
                try {
                    printJob.print();
                }
                catch (PrinterException pe) {
                    System.out.println(pe);
                    JOptionPane.showMessageDialog(ClassroomScheduler.getFrame(), "Error printing a schedule.", "Unknown Printer Error", 0);
                }
            }
        } else {
            try {
                printJob.print();
            }
            catch (PrinterException pe) {
                System.out.println(pe);
                JOptionPane.showMessageDialog(ClassroomScheduler.getFrame(), "Error printing a schedule.", "Unknown Printer Error", 0);
            }
        }
    }

    class ShowIt
    implements ActionListener {
        ShowIt() {
        }

        public void actionPerformed(ActionEvent ae) {
            if (ae.getActionCommand().equalsIgnoreCase("Professor")) {
                ViewCharts.this.availableProfs.setEnabled(true);
                ViewCharts.this.availableRooms.setEnabled(false);
                ViewCharts.this.availableProfs.removeAllItems();
                Iterator it = ViewCharts.this.schedule.getProfessors().iterator();
                while (it.hasNext()) {
                    ViewCharts.this.availableProfs.addItem(it.next());
                }
                ViewCharts.this.viewGraphSched.setViewProf((Professor)ViewCharts.this.availableProfs.getSelectedItem());
                ViewCharts.this.printAllSimilar.setEnabled(true);
            } else if (ae.getActionCommand().equalsIgnoreCase("Classroom")) {
                ViewCharts.this.availableProfs.setEnabled(false);
                ViewCharts.this.availableRooms.setEnabled(true);
                ViewCharts.this.availableRooms.removeAllItems();
                Iterator it = ViewCharts.this.schedule.getClassrooms().iterator();
                while (it.hasNext()) {
                    ViewCharts.this.availableRooms.addItem(it.next());
                }
                ViewCharts.this.viewGraphSched.setViewRoom((Classroom)ViewCharts.this.availableRooms.getSelectedItem());
                ViewCharts.this.printAllSimilar.setEnabled(true);
            } else if (ae.getSource() == ViewCharts.this.availableProfs) {
                ViewCharts.this.viewGraphSched.setViewProf((Professor)ViewCharts.this.availableProfs.getSelectedItem());
                ViewCharts.this.chartScrollPane.revalidate();
            } else if (ae.getSource() == ViewCharts.this.availableRooms) {
                ViewCharts.this.viewGraphSched.setViewRoom((Classroom)ViewCharts.this.availableRooms.getSelectedItem());
                ViewCharts.this.chartScrollPane.revalidate();
            } else if (ae.getSource() == ViewCharts.this.printThis) {
                ViewCharts.this.printTheView(ViewCharts.this.viewGraphSched, true);
            } else if (ae.getSource() == ViewCharts.this.printAllSimilar) {
                if (ViewCharts.this.roomRadioButton.isSelected()) {
                    System.out.println("Print all the rooms");
                    Iterator it = ViewCharts.this.schedule.getClassrooms().iterator();
                    while (it.hasNext()) {
                        ViewCharts.this.viewGraphSched.setViewRoom((Classroom)it.next());
                        ViewCharts.this.printTheView(ViewCharts.this.viewGraphSched, false);
                    }
                }
                if (ViewCharts.this.profRadioButton.isSelected()) {
                    System.out.println("Print all the full time profs");
                    for (Professor p : ViewCharts.this.schedule.getProfessors()) {
                        if (p.getStatus() != 1) continue;
                        ViewCharts.this.viewGraphSched.setViewProf(p);
                        ViewCharts.this.printTheView(ViewCharts.this.viewGraphSched, false);
                    }
                }
            }
        }
    }
}

