/*
 * Decompiled with CFR 0.152.
 */
package resources;

import java.io.Serializable;
import java.text.DateFormatSymbols;
import resources.CRTime;
import resources.CRTimeException;

public class TimeSlot
implements Comparable,
Serializable {
    static final long serialVersionUID = 911L;
    private boolean[] daysOfWeek = new boolean[]{false, false, false, false, false, false, false};
    private CRTime start;
    private CRTime stop;
    private boolean online = false;
    private boolean tba = false;

    public TimeSlot(boolean[] daysOfWeek, CRTime start, CRTime stop) {
        this.daysOfWeek = daysOfWeek;
        this.start = start;
        this.stop = stop;
    }

    public TimeSlot() {
        this.online = false;
        this.start = null;
        this.stop = null;
    }

    public boolean getOnline() {
        return this.online;
    }

    public boolean getTba() {
        return this.tba;
    }

    public TimeSlot setOnline() {
        this.online = true;
        this.tba = false;
        this.daysOfWeek = new boolean[7];
        this.start = null;
        this.stop = null;
        return this;
    }

    public TimeSlot setTba() {
        this.online = false;
        this.tba = true;
        this.daysOfWeek = new boolean[7];
        this.start = null;
        this.stop = null;
        return this;
    }

    public void setStartTime(CRTime start) {
        this.start = start;
    }

    public void setStopTime(CRTime stop) {
        this.stop = stop;
    }

    public CRTime getStartTime() {
        return this.start;
    }

    public CRTime getStopTime() {
        return this.stop;
    }

    public boolean[] getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public int getMinutes() {
        return this.stop.getcrMinutes() - this.start.getcrMinutes();
    }

    public boolean overlap(TimeSlot secondSlot) {
        if (this.online || this.tba || secondSlot.online || secondSlot.tba) {
            return false;
        }
        if (this.daysOverlap(secondSlot)) {
            if (this.getStartTime().getcrMinutes() <= secondSlot.getStartTime().getcrMinutes() && this.getStopTime().getcrMinutes() >= secondSlot.getStartTime().getcrMinutes()) {
                return true;
            }
            if (this.getStartTime().getcrMinutes() >= secondSlot.getStartTime().getcrMinutes() && this.getStartTime().getcrMinutes() <= secondSlot.getStopTime().getcrMinutes()) {
                return true;
            }
        }
        return false;
    }

    private boolean daysOverlap(TimeSlot secondSlot) {
        for (int i = 0; i < this.daysOfWeek.length; ++i) {
            if (!(this.daysOfWeek[i] & secondSlot.daysOfWeek[i])) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String result = "";
        if (this.tba) {
            result = " TBA";
        } else if (this.online) {
            result = " ONLINE";
        } else {
            result = this.toDaysString();
            result = result + " " + this.start.toString() + "-" + this.stop.toString();
        }
        return result;
    }

    public String toDaysString() {
        String result = "";
        if (this.tba) {
            result = "TBA";
        } else if (this.online) {
            result = "ONLINE";
        } else {
            DateFormatSymbols dfs = new DateFormatSymbols();
            String[] stringDays = dfs.getWeekdays();
            for (int i = 0; i < this.daysOfWeek.length; ++i) {
                if (!this.daysOfWeek[i]) continue;
                result = i == 5 ? result + 'R' : result + stringDays[i].charAt(0);
            }
        }
        return result;
    }

    public String toTimeString() {
        String result = "";
        result = this.tba ? "TBA" : (this.online ? "NA" : result + " " + this.start.toString() + "-" + this.stop.toString());
        return result;
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof TimeSlot)) {
            return 0;
        }
        TimeSlot slot = (TimeSlot)obj;
        if (this.tba && slot.tba) {
            return 0;
        }
        if (this.online && slot.online) {
            return 0;
        }
        if (this.tba) {
            return -2;
        }
        if (this.online) {
            return -1;
        }
        if (slot.tba) {
            return 2;
        }
        if (slot.online) {
            return 1;
        }
        if (obj == null) {
            return -1;
        }
        return this.start.compareTo(((TimeSlot)obj).start);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TimeSlot)) {
            return false;
        }
        TimeSlot slot = (TimeSlot)obj;
        if (this.tba && slot.tba) {
            return true;
        }
        if (this.online && slot.online) {
            return true;
        }
        if (this.tba || slot.tba || this.online || slot.online) {
            return false;
        }
        TimeSlot slot2 = (TimeSlot)obj;
        boolean result = false;
        return this.start.equals(slot2.start) && this.stop.equals(slot2.stop) && this.daysEqual(this.daysOfWeek, slot2.daysOfWeek);
    }

    private boolean daysEqual(boolean[] days1, boolean[] days2) {
        for (int i = 0; i < days1.length && i < days2.length; ++i) {
            if (days1[i] == days2[i]) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] a) {
        CRTime start = null;
        CRTime stop = null;
        boolean[] days = new boolean[]{false, false, true, false, true, true, true, false};
        try {
            start = new CRTime(299);
            stop = new CRTime(350);
        }
        catch (CRTimeException crtE) {
            System.out.println(crtE);
        }
        TimeSlot slot = new TimeSlot(days, start, stop);
        System.out.println(slot);
    }
}

