
/**
 *  Classroom Scheduler
 *  Copyright (C) 2004 Colin Archibald, Ph.D.
 *  https://sourceforge.net/projects/cr-scheduler/
 *
 *  Licensed under the Academic Free License version 2.0
 *
 */

package application;

import resources.*;

/**
 *
 * @author  Kyle Murphy
 */
public class DummySchedule {
    
    /**
     * Hard code a schedule for testing and development
     */
    public static void makeDummySchedule() {
        Schedule schedule = Schedule.getSchedule();
        
        Professor colin = new Professor("Colin", "Archibald", Professor.FULL_TIME);
        Professor jeff = new Professor("Jeff", "Abernathy", Professor.ADJUNCT);
        Professor terry = new Professor("Terry", "Long", Professor.FULL_TIME);
        Professor john = new Professor("John", "Doe", Professor.FULL_TIME);
        
        try{
            schedule.addProfessor(colin);
//            Thread.sleep(1000);
            schedule.addProfessor(terry);
//            Thread.sleep(1000);
            schedule.addProfessor(jeff);
//            Thread.sleep(1000);
            schedule.addProfessor(john);
//            Thread.sleep(1000);
   
            Course java = new Course("COP", "2800", "Intro Java Programming", "W", 1, 3);
            Course java2 = new Course("COP", "2800", "Intro Java Programming", "W", 2, 3);
            Course micro = new Course("CGS", "2100", "Intro MicroFund & Apps", "W", 1, 3);
            Course micro2 = new Course("CGS", "2100", "Intro MicroFund & Apps", "W", 2, 3);
            Course micro3 = new Course("CGS", "2100", "Intro MicroFund & Apps", "W", 3, 3);
            Course micro4 = new Course("CGS", "2100", "Intro MicroFund & Apps", "W", 4, 3);
            Course javafp = new Course("COP", "2700", "Java for Programmers", "W", 1, 2);
    //        Thread.sleep(1000);
            schedule.addCourse(java);
    //        Thread.sleep(1000);
            schedule.addCourse(java2);
    //        Thread.sleep(1000);
            schedule.addCourse(micro);
    //        Thread.sleep(1000);
            schedule.addCourse(micro2);
    //        Thread.sleep(1000);
            schedule.addCourse(micro3);
    //        Thread.sleep(1000);
            schedule.addCourse(micro4);
    //        Thread.sleep(1000);
            schedule.addCourse(javafp);
    //        Thread.sleep(1000);

            Classroom rm129 = new Classroom("7", "129", 24);
            Classroom rm122 = new Classroom("7", "122", 27);
            Classroom rm120 = new Classroom("7", "120", 27);
            Classroom rm210 = new Classroom("7", "210", 20);

            schedule.addClassroom(rm129);
            schedule.addClassroom(rm122);
            schedule.addClassroom(rm120);
            schedule.addClassroom(rm210);

            Textbook cBook = new Textbook("C A Modern Approach","2nd","KN King",
                "WW Norton", "2002", "1-234-567-09");
            Textbook javaBook = new Textbook("Computer Science with Java", "3rd",
                "W. Savitch", "Prentice Hall", "2004", "123-345-56-1");
            schedule.addBook(cBook);
            schedule.addBook(javaBook);
        
       
            boolean[] days1 = { false, false, true, false, true, false, true, false };
            CRTime time1 = new CRTime(60);
            CRTime time2 = new CRTime(110);            
            TimeSlot slot1 = new TimeSlot(days1, time1, time2);
            
            boolean[] days2 = { false, false, false, true,  false, true,
            false, false };
            boolean[] days3 = { false, false, false, true,  false, true, false,
            false };
          
            CRTime time3 = new CRTime(115);
            CRTime time4 = new CRTime(185);
            TimeSlot slot2 = new TimeSlot(days2, time3, time4);
            
            time3 = new CRTime(0);
            time4 = new CRTime(50);
            TimeSlot slot3 = new TimeSlot(days3, time3, time4);
            
            boolean[] days4 = { false, false, false, true, false, false,
            false, false };
            
            CRTime time5 = new CRTime(190);
            CRTime time6 = new CRTime(290);
            TimeSlot slot4 = new TimeSlot(days4, time5, time6);
            
            schedule.addTimeSlot(slot1);
            schedule.addTimeSlot(slot2);
            schedule.addTimeSlot(slot3);
            schedule.addTimeSlot(slot4);
            
            SchedCourse sc1 = new SchedCourse(colin, rm129, java, slot1,"12345");
            sc1.setNote("Contact Professor Archibald for information: carchibald@valenciacc.edu");
            SchedCourse sc2 = new SchedCourse(terry, rm129, micro, slot2,"23456");
            SchedCourse sc3 = new SchedCourse(terry, rm120, micro2, slot2,"34567");
            SchedCourse sc4 = new SchedCourse(jeff, rm122, micro3, slot2, "45678");
            SchedCourse sc5 = new SchedCourse(colin, rm122, java2, slot1,"78901");
            SchedCourse sc6 = new SchedCourse(john, rm210, javafp, slot4,"38261");
            schedule.addSchedCourse(sc1);
            schedule.addSchedCourse(sc2);
            schedule.addSchedCourse(sc3);
            schedule.addSchedCourse(sc4);
            schedule.addSchedCourse(sc5);
            schedule.addSchedCourse(sc6);
        }
        catch (Exception ce) {
            System.out.println("Exception during dummy schedule" + ce);
        }
    }
    
}
