/*
 * UserPreferences.java
 *
 * Created on August 1, 2004, 5:08 PM
 *
 * Keeps track of the user preferences.  Each one will be documented as it is added.
 * Try to keep these simple.  Don't make external classes that represent sets of 
 * preferences.  If a class is needed, define it in here.
 *
 */

package application;

/**
 * @author  Colin
 *
 *  This is a Singleton.  There will only be one of them application wide.
 *  Not sure what approach to take.  I don't think I'll store them here as instance variables.
 *  I'll keep going back to the registry, and allow them to be stored there only.
 *
 */

import java.util.prefs.*;

public class UserPreferences {
    
    private static UserPreferences preferences = null;
    private Preferences prefs; // this is the object supplied by sdk
    
    // The constructor reads the prefs from the registry.  They will be changed
    // and put back into the registry as the user works.  This is the only place
    // will all be 
    private UserPreferences() {
         prefs =
            Preferences.userNodeForPackage(this.getClass()); 

        int thePref = prefs.getInt("TestPref", 40);
        System.out.println("Testing prefs.  I got: \n"+ thePref);
        prefs.putInt("TestPref", 99);

    }
    
    public static UserPreferences getPrefs(){
        if( preferences == null){
            return new UserPreferences();
        } else {
            return preferences;
        }
    }
}
