/**
 *  Classroom Scheduler
 *  Copyright (C) 2004 Colin Archibald, Ph.D.
 *  https://sourceforge.net/projects/cr-scheduler/
 *
 *  Licensed under the Academic Free License version 2.0
 */

package panels;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.border.*;
import application.*;
import resources.*;

// This class appears to no longer be used (took me a hour and a half to figure this
// one out, thanks Dr. Archibald. Appears to have been replaced by ModifySchedule.java

/**
 * A panel on the tabbed pane to allow the user to look at an modify
 * the scheduled items for this schedule.
 * Don't think this class i used anymore!
 */

public class ScheduleCoursePanel extends Box implements Observer {
    private JLabel label;
    private JTable schedTable;
    private ScheduleTableModel scheduleTableModel;
    private TableColumn classroomColumn;
    private TableColumn timeSlotColumn;
    private TableColumn professorColumn;
    private TableColumn courseColumn;
    private	JScrollPane scheduleScrollPane;
    private JList courseList;
    private JScrollPane courseScrollPane;
    private JComboBox professorCB, timeSlotCB, classroomCB;
    private JComboBox professorTableCB, timeSlotTableCB, classroomTableCB;
    private JButton addButton, deleteButton;
    
    private ScheduleCoursePanelListener scheduleCoursePanelListener;
    private Schedule schedule = Schedule.getSchedule();
    private Component parent;
    
    public ScheduleCoursePanel(Component parent) {
        super(BoxLayout.X_AXIS);
        
        this.parent = parent;
        makeWidgets();
        doTheLayout();
        addToolTips();
        addListeners();
    }
    
    public void update(Observable o, Object arg) {
        scheduleTableModel.fireTableDataChanged();
        
        
        // add the unscheduled courses to the list available to schedule
        ArrayList courses = schedule.getCourses();
        Vector unScheduledCourses = new Vector(20,10);
        
        for (Iterator it = courses.iterator(); it.hasNext(); ){
            Course course = (Course) it.next();
            if (!(course.getIsScheduled()))
                unScheduledCourses.add(course);
        }      
        courseList.setListData(unScheduledCourses);
        
        professorCB.removeAllItems();
        Iterator it = schedule.getProfessors().iterator();
        while(it.hasNext())
            professorCB.addItem(it.next());
        
        timeSlotCB.removeAllItems();
        it = schedule.getTimeSlots().iterator();
        while(it.hasNext())
            timeSlotCB.addItem(it.next());
        
        classroomCB.removeAllItems();
        it = schedule.getClassrooms().iterator();
        while(it.hasNext())
            classroomCB.addItem(it.next());
        
        // repeat for the table Combo boxes
        professorTableCB.removeAllItems();
        it = schedule.getProfessors().iterator();
        while(it.hasNext())
            professorTableCB.addItem(it.next());
        
        timeSlotTableCB.removeAllItems();
        it = schedule.getTimeSlots().iterator();
        while(it.hasNext())
            timeSlotTableCB.addItem(it.next());
        
        classroomTableCB.removeAllItems();
        it = schedule.getClassrooms().iterator();
        while(it.hasNext())
            classroomTableCB.addItem(it.next());
        
    }
    
    private void makeWidgets() {
        professorCB = new JComboBox();  // appears easier to add the elements here as a parameter to constuctor
        timeSlotCB = new JComboBox();
        classroomCB = new JComboBox();
        professorTableCB = new JComboBox();  // appears easier to add the elements here as a parameter to constuctor
        timeSlotTableCB = new JComboBox();
        classroomTableCB = new JComboBox();
        
        addButton = new JButton(" Add To Schedule ");
        deleteButton = new JButton(" Remove Selected Item(s) ");
        courseList = new JList();
        courseList.setVisibleRowCount(15);
        courseList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        
        courseScrollPane = new JScrollPane(courseList,
        ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
        ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        
        // the table for the schedule
        scheduleTableModel = new ScheduleTableModel();
        schedTable = new JTable(scheduleTableModel);
        
        scheduleScrollPane = new JScrollPane(schedTable,
        ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
        ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        
        schedTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        
        courseColumn = schedTable.getColumnModel().getColumn(0);
        classroomColumn = schedTable.getColumnModel().getColumn(1);
        timeSlotColumn = schedTable.getColumnModel().getColumn(2);
        professorColumn = schedTable.getColumnModel().getColumn(3);
        classroomColumn.setCellEditor(new DefaultCellEditor(classroomTableCB));
        timeSlotColumn.setCellEditor(new DefaultCellEditor(timeSlotTableCB));
        professorColumn.setCellEditor(new DefaultCellEditor(professorTableCB));
    }
    
    private void doTheLayout() {
        add(Box.createHorizontalGlue());
        add(Box.createHorizontalStrut(25));
        
        Box leftPanel = new Box(BoxLayout.Y_AXIS);
        Box rightPanel = new Box(BoxLayout.Y_AXIS);
        
        leftPanel.add(Box.createVerticalStrut(25));
        leftPanel.add(scheduleScrollPane);
        leftPanel.add(Box.createVerticalStrut(25));
        leftPanel.add(deleteButton);
        leftPanel.add(Box.createVerticalStrut(25));
        
        add(leftPanel);
        add(Box.createHorizontalStrut(25));
        
        rightPanel.add(Box.createVerticalStrut(25));
        label = (JLabel) rightPanel.add(new JLabel("Courses not in schedule:"));
        label.setAlignmentX(JLabel.LEFT_ALIGNMENT);
        rightPanel.add(courseScrollPane);
        
        label = (JLabel) rightPanel.add(new JLabel("Time Slot:"));
        label.setAlignmentX(JLabel.LEFT_ALIGNMENT);
        rightPanel.add(timeSlotCB);
        rightPanel.add(Box.createVerticalStrut(5));
        
        label = (JLabel) rightPanel.add(new JLabel("Classroom:"));
        label.setAlignmentX(JLabel.LEFT_ALIGNMENT);
        rightPanel.add(classroomCB);
        rightPanel.add(Box.createVerticalStrut(5));
        
        label = (JLabel) rightPanel.add(new JLabel("Professor:"));
        label.setAlignmentX(JLabel.LEFT_ALIGNMENT);
        rightPanel.add(professorCB);
        
        rightPanel.add(Box.createVerticalStrut(25));
        rightPanel.add(addButton);
        rightPanel.add(Box.createVerticalStrut(25));
        add(rightPanel);
        
        add(Box.createHorizontalStrut(25));
        add(Box.createHorizontalGlue());
    }
    
    private void addToolTips() {
        courseList.setToolTipText("Select a course to schedule");
        professorCB.setToolTipText("Select a Professor");
        timeSlotCB.setToolTipText("Select a Time Slot");
        classroomCB.setToolTipText("Select a Classroom");
        addButton.setToolTipText("Add this item to the schedule");
        deleteButton.setToolTipText("Remove the selected items(s) from the list of scheduled courses");
        
        //Set up tool tips for the table cells.
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        
        classroomColumn.setCellRenderer(renderer);
        timeSlotColumn.setCellRenderer(renderer);
        professorColumn.setCellRenderer(renderer);
        renderer.setToolTipText("Click to change the value in this cell");
        
        DefaultTableCellRenderer rendererForCourseCol = new
        DefaultTableCellRenderer();
        courseColumn.setCellRenderer(rendererForCourseCol);
        rendererForCourseCol.setToolTipText("Select courses to be un-scheduled");
    }
    
    private void addListeners() {
        scheduleCoursePanelListener = new ScheduleCoursePanelListener();
        addButton.addActionListener(scheduleCoursePanelListener);
        deleteButton.addActionListener(scheduleCoursePanelListener);
        
        classroomTableCB.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                int row = schedTable.getEditingRow();
                if (row >= 0) {
                    Classroom c = (Classroom)((JComboBox)e.getSource()).getSelectedItem();
                    SchedCourse courseModified = (SchedCourse)schedule.getSchedCourses().get(row);
                    courseModified.setClassroom(c);
                    //Schedule.getSchedule().findConflicts();
                    scheduleTableModel.fireTableDataChanged();
                    schedule.setChanged(true);
                }
            }
        });
        
        timeSlotTableCB.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                int row = schedTable.getEditingRow();
                if (row >= 0) {
                    TimeSlot t = (TimeSlot)((JComboBox)e.getSource()).getSelectedItem();
                    SchedCourse courseModified = (SchedCourse)schedule.getSchedCourses().get(row);
                    courseModified.setTimeSlot(t);
                    //Schedule.getSchedule().findConflicts();
                    scheduleTableModel.fireTableDataChanged();
                    schedule.setChanged(true);
                }
            }
        });
        
        professorTableCB.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                int row = schedTable.getEditingRow();
                if (row >= 0) {
                    Professor p = (Professor)((JComboBox)e.getSource()).getSelectedItem();
                    SchedCourse courseModified = (SchedCourse)schedule.getSchedCourses().get(row);
                    courseModified.setProfessor(p);
                    //Schedule.getSchedule().findConflicts();
                    scheduleTableModel.fireTableDataChanged();
                    schedule.setChanged(true);
                }
            }
        });
    }
    
    
    /**
     * Inner class to handle the events
     */
    
    class ScheduleCoursePanelListener implements ActionListener {
        /**
         * @param e
         *
         */
        
        public void actionPerformed(ActionEvent e) {
            
            if (e.getSource() == addButton) {
                Course[] coursesToSchedule = (Course[]) courseList.getSelectedValues();
                                
                if (coursesToSchedule.length == 0) {
                    JOptionPane.showMessageDialog(parent, "Select a course to be scheduled");
                    return;
                }
                
                Professor profToSchedule = (Professor) professorCB.getSelectedItem();
                
                if (profToSchedule == null) {
                    JOptionPane.showMessageDialog(parent, "Select a professor to be scheduled");
                    return;
                }
                
                TimeSlot timeSlotToSchedule = (TimeSlot) timeSlotCB.getSelectedItem();
                if (timeSlotToSchedule == null) {
                    JOptionPane.showMessageDialog(parent, "Select a time slot to schedule");
                    return;
                }
                
                int selected = classroomCB.getSelectedIndex();
                if (selected < 0) {
                    JOptionPane.showMessageDialog(parent, "Select a room to schedule");
                    return;
                }
                
                Classroom classroomToSchedule = (Classroom) schedule.getClassrooms().get(selected);
                
                for(int i = 0; i < coursesToSchedule.length; i++) {
                    SchedCourse theNewScheduledCourse = new SchedCourse(
                    profToSchedule,
                    classroomToSchedule,
                    coursesToSchedule[i],
                    timeSlotToSchedule);
                    schedule.addSchedCourse(theNewScheduledCourse);
                }
            } else if (e.getSource() == deleteButton) {
                // Determine which items to be deleted.
                int[] selected = schedTable.getSelectedRows();
                
                for (int i = selected.length - 1; i >= 0; i--) {
                    // Removes the items from the list
                    schedule.removeSchedCourse((SchedCourse) schedule.getSchedCourses().get(selected[i]));
                }
            }
        }
    } // end inner class
}
