/**
 *  Classroom Scheduler
 *  Copyright (C) 2004 Colin Archibald, Ph.D.
 *  https://sourceforge.net/projects/cr-scheduler/
 *
 *  Licensed under the Academic Free License version 2.0
 */

package panels;

import javax.swing.*;
import javax.swing.table.*;
import application.*;
import resources.*;

class ScheduleTableModel extends AbstractTableModel {
    
    private Schedule schedule = Schedule.getSchedule();
    
    final String[] columnNames = { 
    "Course",
    "CRN",
    "Classroom",
    "Time Slot",
    "Professor",
    "Conflict",
    "Note" };
    
    //final Object[][] data = ...//same as before...
    
    public int getColumnCount() {
        return columnNames.length;
    }
    
    public int getRowCount() {
        return schedule.getSchedCourses().size();
    }
    
    public String getColumnName(int col) {
        return columnNames[col];
    }
    
    public Object getValueAt(int row, int col) {
        Object result = null;
        SchedCourse schedCourse = (SchedCourse)schedule.getSchedCourses().get(row);
        switch (col) {
            case 0:
                result = schedCourse.getCourse();
                break;
            case 1:
                result = schedCourse.getCrn();
                break;
            case 2:
                result = schedCourse.getClassroom();
                break;
            case 3:
                result = schedCourse.getTimeSlot();
                break;
            case 4:
                result = schedCourse.getProfessor();
                break;
            case 5: {
                boolean conflict = schedCourse.getConflict() == null ? false : true;
                result = new Boolean(conflict);
                break;
            }
            case 6:
                result = schedCourse.getNote();
                break;       
            default:
                System.out.println("Tried to access table data outside 0-6:" + "[" + row + ", " + col);
        }
        return result;
    }
    
    public Class getColumnClass(int c) {
        return getValueAt(0, c).getClass();
    }
    
    public boolean isCellEditable(int row, int col) {
        if (col == 0 || col == 5)  // the course, and the conflicts are not editable by user.
            return false;
        else
            return true;
    }
    
        /*
         * When table data changes
         */
    
    public void setValueAt(Object value, int row, int col) {        
        SchedCourse schedCourse = (SchedCourse)schedule.getSchedCourses().get(row);
        schedule.removeSchedCourse(schedCourse);
        if(value != null){
            switch (col) {
                case 0: // This should never happen, un-editable
                    schedCourse.setCourse((Course) value);
                    break;
                case 1:
                    schedCourse.setCrn((String) value);
                    break;
                case 2:
                    schedCourse.setClassroom((Classroom) value);
                    break;
                case 3:      
                    schedCourse.setTimeSlot((TimeSlot) value);
                    break;
                case 4:                
                    schedCourse.setProfessor((Professor) value);
                    break;
                case 5: // This should never happen, un-editable                
                    break;            
                case 6:
                    schedCourse.setNote((String) value);
                    break;       
                default:
                    System.out.println("Tried to set table data outside 0-6:" + "[" + row + ", " + col);
            } 
        }
        schedule.addSchedCourse(schedCourse); // maybe put the same one back
        // Would like to do CellUpdated, but all the cells may have changed due to the conflict
        //fireTableCellUpdated(row, col);
        fireTableDataChanged();
    }
}
