/*
 * Decompiled with CFR 0.152.
 */
package plugins.collaboration.socket;

import freemind.controller.MenuItemEnabledListener;
import freemind.controller.MenuItemSelectedListener;
import freemind.extensions.HookRegistration;
import freemind.extensions.PermanentNodeHook;
import freemind.modes.MindMap;
import freemind.modes.ModeController;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.NodeHookAction;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import plugins.collaboration.socket.MindMapMaster;
import plugins.collaboration.socket.SocketConnectionHook;

public class SocketRegistration
implements HookRegistration,
MenuItemSelectedListener,
MenuItemEnabledListener {
    private final MindMapController mController;
    private final Logger logger;
    private MindMap mMap;

    public SocketRegistration(ModeController controller, MindMap map) {
        this.mController = (MindMapController)controller;
        this.mMap = map;
        this.logger = controller.getFrame().getLogger(this.getClass().getName());
    }

    public void register() {
        this.logger.fine("Registration of database registration.");
    }

    public void deRegister() {
        this.logger.fine("Deregistration of database registration.");
    }

    public boolean isSelected(JMenuItem pCheckItem, Action pAction) {
        NodeHookAction action;
        this.logger.fine(this + " is asked for " + pAction + ".");
        if (pAction instanceof NodeHookAction && (action = (NodeHookAction)pAction).getHookName().equals("plugins/collaboration/socket/socket_slave_starter_plugin")) {
            return this.isSlave();
        }
        return this.isMaster();
    }

    private boolean isMaster() {
        Collection activatedHooks = this.mController.getRootNode().getActivatedHooks();
        for (PermanentNodeHook hook : activatedHooks) {
            if (!(hook instanceof MindMapMaster)) continue;
            return true;
        }
        return false;
    }

    private boolean isSlave() {
        Collection activatedHooks = this.mController.getRootNode().getActivatedHooks();
        for (PermanentNodeHook hook : activatedHooks) {
            if (!(hook instanceof SocketConnectionHook)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled(JMenuItem pItem, Action pAction) {
        NodeHookAction action;
        this.logger.fine(this + " is asked for " + pAction + ".");
        if (pAction instanceof NodeHookAction && (action = (NodeHookAction)pAction).getHookName().equals("plugins/collaboration/socket/socket_slave_starter_plugin")) {
            return !this.isMaster();
        }
        return !this.isSlave();
    }
}

