/*
 * Decompiled with CFR 0.152.
 */
package org.dpolivaev.mnemonicsetter;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.dpolivaev.mnemonicsetter.ButtonNameMnemonicHolder;
import org.dpolivaev.mnemonicsetter.INameMnemonicHolder;
import org.dpolivaev.mnemonicsetter.ItemMnemonicSetter;
import org.dpolivaev.mnemonicsetter.MenuItemMnemonicHolder;
import org.dpolivaev.mnemonicsetter.UsedAltAcceleratorsFinder;

public class MnemonicSetter
implements PopupMenuListener {
    private static final boolean IS_MAC_OS = System.getProperty("os.name").startsWith("Mac OS");
    public static final MnemonicSetter INSTANCE = new MnemonicSetter();

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        Container popupMenu = (Container)e.getSource();
        this.setComponentMnemonics(popupMenu);
    }

    public void setComponentMnemonics(Container ... containers) {
        if (IS_MAC_OS) {
            return;
        }
        int componentCount = 0;
        for (Container container : containers) {
            componentCount += container.getComponentCount();
        }
        HashSet<Integer> keyCodesUsedInMenus = new HashSet<Integer>();
        ArrayList<INameMnemonicHolder> mnemonicHolders = new ArrayList<INameMnemonicHolder>(componentCount);
        for (Container container : containers) {
            Component[] components;
            if (container instanceof JMenuBar) {
                Collection<Integer> keyCodesUsedInMenu = UsedAltAcceleratorsFinder.INSTANCE.findUsedKeyCodes((JMenuBar)container);
                keyCodesUsedInMenus.addAll(keyCodesUsedInMenu);
            }
            for (Component component : components = container.getComponents()) {
                if (component instanceof JMenuItem) {
                    JMenuItem item = (JMenuItem)component;
                    mnemonicHolders.add(new MenuItemMnemonicHolder(item));
                    continue;
                }
                if (!(component instanceof AbstractButton)) continue;
                AbstractButton button = (AbstractButton)component;
                mnemonicHolders.add(new ButtonNameMnemonicHolder(button));
            }
        }
        ItemMnemonicSetter mnemonicSetter = ItemMnemonicSetter.of(mnemonicHolders).notUsing(keyCodesUsedInMenus);
        mnemonicSetter.setMnemonics();
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }
}

