/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceBundles;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.ActionAcceleratorManager;
import org.freeplane.core.ui.LengthUnits;
import org.freeplane.core.ui.TimePeriodUnits;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.Quantity;
import org.freeplane.features.mode.AController;
import org.freeplane.features.mode.Controller;

public abstract class ResourceController {
    public static final String FREEPLANE_PROPERTIES = "/freeplane.properties";
    public static final String LOCAL_PROPERTIES = "LocalProperties.";
    public static final String RESOURCE_DRAW_RECTANGLE_FOR_SELECTION = "standarddrawrectangleforselection";
    public static final String PLUGIN_DEFAULTS_RESOURCE = "defaults.properties";
    private final List<IFreeplanePropertyListener> propertyChangeListeners = new Vector<IFreeplanePropertyListener>();
    private static ActionAcceleratorManager acceleratorManager;
    private ResourceBundles resources;
    public static final String FREEPLANE_RESOURCE_URL_PROTOCOL = "freeplaneresource";
    public static final String OBJECT_TYPE = "ObjectType";

    public static ResourceController getResourceController() {
        return Controller.getCurrentController().getResourceController();
    }

    public void addLanguageResources(String language, URL url) {
        this.resources.addResources(language, url);
    }

    public void addLanguageResources(String language, Map<String, String> resources) {
        this.resources.addResources(language, resources);
    }

    public void putUserResourceString(String key, String value) {
        this.resources.putUserResourceString(key, value);
    }

    public void addPropertyChangeListener(IFreeplanePropertyListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public void addPropertyChangeListenerAndPropagate(IFreeplanePropertyListener listener) {
        this.addPropertyChangeListener(listener);
        for (Map.Entry<Object, Object> entry : this.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            listener.propertyChanged(key, (String)entry.getValue(), null);
        }
    }

    protected void loadAnotherLanguage() {
        this.resources.loadAnotherLanguage(this.getProperty("language"));
    }

    public void firePropertyChanged(String property, String value, String oldValue) {
        if (oldValue == null || !oldValue.equals(value)) {
            this.setProperty(property, value);
            for (IFreeplanePropertyListener listener : this.getPropertyChangeListeners()) {
                listener.propertyChanged(property, value, oldValue);
            }
        }
    }

    public boolean getBooleanProperty(String key) {
        return Boolean.parseBoolean(this.getProperty(key));
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = this.getProperty(key, null);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    public <T extends Enum<T>> T getEnumProperty(String propertyName, Enum<T> defaultValue) {
        try {
            String cacheProptertyValue = this.getProperty(propertyName).toUpperCase(Locale.ENGLISH);
            defaultValue = Enum.valueOf(defaultValue.getClass(), cacheProptertyValue);
        }
        catch (Exception e) {
            LogUtils.severe(e);
        }
        return (T)defaultValue;
    }

    public String getDefaultProperty(String key) {
        return null;
    }

    public double getDoubleProperty(String key, double defaultValue) {
        try {
            return Double.parseDouble(ResourceController.getResourceController().getProperty(key));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public abstract String getFreeplaneUserDirectory();

    public int getIntProperty(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.getProperty(key));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public int getLengthProperty(String name) {
        Quantity<LengthUnits> quantity = this.getLengthQuantityProperty(name);
        return quantity.toBaseUnitsRounded();
    }

    public Quantity<LengthUnits> getLengthQuantityProperty(String name) {
        String property = this.getProperty(name);
        Quantity<LengthUnits> quantity = Quantity.fromString(property, LengthUnits.px);
        return quantity;
    }

    public int getTimeProperty(String name) {
        Quantity<TimePeriodUnits> quantity = this.getTimeQuantityProperty(name);
        return quantity.toBaseUnitsRounded();
    }

    public Quantity<TimePeriodUnits> getTimeQuantityProperty(String name) {
        String property = this.getProperty(name);
        Quantity<TimePeriodUnits> quantity = Quantity.fromString(property, TimePeriodUnits.ms);
        return quantity;
    }

    public int getIntProperty(String key) {
        return Integer.parseInt(this.getProperty(key));
    }

    public double getDoubleProperty(String key) {
        return Double.parseDouble(this.getProperty(key));
    }

    public long getLongProperty(String key, int defaultValue) {
        try {
            return Long.parseLong(this.getProperty(key));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public abstract Properties getProperties();

    public abstract String getProperty(String var1);

    public String getProperty(String key, String value) {
        return this.getProperties().getProperty(key, value);
    }

    public Collection<IFreeplanePropertyListener> getPropertyChangeListeners() {
        return Collections.unmodifiableCollection(this.propertyChangeListeners);
    }

    public URL getResource(String name) {
        return this.getClass().getResource(name);
    }

    public InputStream getResourceStream(String resFileName) throws IOException {
        URL resUrl = this.getResource(resFileName);
        if (resUrl == null) {
            LogUtils.severe("Can't find " + resFileName + " as resource.");
            throw new IllegalArgumentException("Can't find " + resFileName + " as resource.");
        }
        return new BufferedInputStream(resUrl.openStream());
    }

    public String getResourceBaseDir() {
        return "";
    }

    public String getInstallationBaseDir() {
        return "";
    }

    public ResourceBundle getResources() {
        if (this.resources == null) {
            this.resources = new ResourceBundles(this.getProperty("language"));
        }
        return this.resources;
    }

    public String getLanguageCode() {
        return this.resources.getLanguageCode();
    }

    public String getDefaultLanguageCode() {
        return this.resources.getDefaultLanguageCode();
    }

    public String getText(String key, String resource) {
        return ((ResourceBundles)this.getResources()).getResourceString(key, resource);
    }

    protected void init() {
    }

    public void removePropertyChangeListener(IFreeplanePropertyListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    public abstract void saveProperties();

    public abstract void setDefaultProperty(String var1, String var2);

    public void setProperty(String property, boolean value) {
        this.setProperty(property, Boolean.toString(value));
    }

    public void setProperty(String name, int value) {
        this.setProperty(name, Integer.toString(value));
    }

    public abstract void setProperty(String var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static boolean loadProperties(Properties resultProps, URL url) {
        boolean bl;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(url.openStream());
            resultProps.load(in);
            LogUtils.info("Loaded properties from " + url);
            bl = true;
        }
        catch (Exception ex) {
            try {
                System.err.println("Could not load properties from " + url);
            }
            catch (Throwable throwable) {
                FileUtils.silentlyClose(in);
                throw throwable;
            }
            FileUtils.silentlyClose(in);
            return false;
        }
        FileUtils.silentlyClose(in);
        return bl;
    }

    public void addDefaults(URL propertiesUrl) {
        Properties props = new Properties();
        ResourceController.loadProperties(props, propertiesUrl);
        this.addDefaults(props);
    }

    public <KT, VT> void addDefaults(Map<KT, VT> defaultProperties) {
        for (Map.Entry<KT, VT> entry : defaultProperties.entrySet()) {
            this.setDefaultProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public boolean isApplet() {
        return false;
    }

    public void removePropertyChangeListener(Class<? extends AController.IActionOnChange> clazz, AFreeplaneAction action) {
        Iterator<IFreeplanePropertyListener> iterator = this.propertyChangeListeners.iterator();
        while (iterator.hasNext()) {
            IFreeplanePropertyListener next = iterator.next();
            if (!(next instanceof AController.IActionOnChange) || ((AController.IActionOnChange)((Object)next)).getAction() != action) continue;
            iterator.remove();
            return;
        }
    }

    public ActionAcceleratorManager getAcceleratorManager() {
        if (acceleratorManager == null) {
            acceleratorManager = new ActionAcceleratorManager();
        }
        return acceleratorManager;
    }
}

