/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.plaf.basic.BasicButtonUI;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.PropertyBean;
import org.freeplane.core.ui.ColorTracker;
import org.freeplane.core.ui.components.JFreeplaneMenuItem;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.TextUtils;

public class ColorProperty
extends PropertyBean
implements IPropertyControl,
ActionListener {
    Color color;
    private final String defaultColor;
    JButton mButton;
    final JPopupMenu menu = new JPopupMenu();

    public ColorProperty(String name, String defaultColor) {
        super(name);
        this.defaultColor = defaultColor;
        this.mButton = new JButton(){
            private static final long serialVersionUID = 1L;
            {
                this.setUI(BasicButtonUI.createUI(this));
            }
        };
        this.mButton.addActionListener(this);
        this.color = Color.BLACK;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Color result = ColorTracker.showCommonJColorChooserDialog(this.mButton.getRootPane(), TextUtils.getOptionalText(this.getLabel()), this.getColorValue(), ColorUtils.stringToColor(this.defaultColor));
        if (result != null) {
            this.setColorValue(result);
            this.firePropertyChangeEvent();
        }
    }

    public Color getColorValue() {
        return this.color;
    }

    @Override
    public String getValue() {
        Color colorValue = this.getColorValue();
        return ColorUtils.colorToRGBAString(colorValue);
    }

    @Override
    public void layout(DefaultFormBuilder builder) {
        this.layout(builder, this.mButton);
        JFreeplaneMenuItem item = new JFreeplaneMenuItem(TextUtils.getOptionalText("ColorProperty.ResetColor"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorProperty.this.setValue(ColorProperty.this.defaultColor);
            }
        });
        this.menu.add(item);
        this.mButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    ColorProperty.this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    ColorProperty.this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
    }

    public void setColorValue(Color input) {
        this.color = input;
        if (input == null) {
            input = Color.WHITE;
        }
        this.mButton.setBackground(ColorUtils.alphaToColor(255, input));
        Color textColor = UITools.getTextColorForBackground(input);
        this.mButton.setForeground(textColor);
        this.mButton.setText(ColorUtils.colorToString(input));
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.mButton.setEnabled(pEnabled);
    }

    @Override
    public void setValue(String value) {
        this.setColorValue(ColorUtils.stringToColor(value));
    }
}

