/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.PropertyBean;
import org.freeplane.core.ui.components.JComboBoxWithBorder;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;

public class ComboProperty
extends PropertyBean
implements IPropertyControl,
ActionListener {
    final JComboBox mComboBox;
    private Vector<String> possibleValues;

    public static Vector<String> translate(String[] possibles) {
        Vector<String> possibleTranslations = new Vector<String>(possibles.length);
        for (int i = 0; i < possibles.length; ++i) {
            possibleTranslations.add(TextUtils.getText("OptionPanel." + possibles[i]));
        }
        return possibleTranslations;
    }

    public ComboProperty(String name, Collection<String> possibles, Collection<String> possibleTranslations) {
        super(name);
        this.fillPossibleValues(possibles);
        this.mComboBox = new JComboBoxWithBorder();
        this.mComboBox.setModel(new DefaultComboBoxModel<String>(new Vector<String>(possibleTranslations)));
        this.mComboBox.addActionListener(this);
    }

    public ComboProperty(String name, String[] strings) {
        this(name, Arrays.asList(strings), ComboProperty.translate(strings));
    }

    private void fillPossibleValues(Collection<String> possibles) {
        this.possibleValues = new Vector();
        this.possibleValues.addAll(possibles);
    }

    @Override
    public String getValue() {
        if (this.mComboBox.getSelectedIndex() == -1) {
            return this.mComboBox.getSelectedItem().toString();
        }
        return this.possibleValues.get(this.mComboBox.getSelectedIndex());
    }

    @Override
    public void layout(DefaultFormBuilder builder) {
        this.layout(builder, this.mComboBox);
    }

    public Vector<String> getPossibleValues() {
        return this.possibleValues;
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.mComboBox.setEnabled(pEnabled);
    }

    @Override
    public void setValue(String value) {
        if (this.possibleValues.contains(value)) {
            this.mComboBox.setSelectedIndex(this.possibleValues.indexOf(value));
        } else if (this.mComboBox.isEditable()) {
            this.mComboBox.setSelectedItem(value);
        } else {
            LogUtils.severe("Can't set the value:" + value + " into the combo box " + this.getName() + " containing values " + this.possibleValues);
            if (this.mComboBox.getModel().getSize() > 0) {
                this.mComboBox.setSelectedIndex(0);
            }
        }
    }

    public void updateComboBoxEntries(List<String> possibles, List<String> possibleTranslations) {
        this.mComboBox.setModel(new DefaultComboBoxModel<String>(new Vector<String>(possibleTranslations)));
        this.fillPossibleValues(possibles);
        if (possibles.size() > 0) {
            this.mComboBox.setSelectedIndex(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.firePropertyChangeEvent();
    }

    public void setEditable(boolean aFlag) {
        this.mComboBox.setEditable(aFlag);
    }

    public boolean isEditable() {
        return this.mComboBox.isEditable();
    }
}

