/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.PropertyBean;

public class NumberProperty
extends PropertyBean
implements IPropertyControl {
    private final JSpinner spinner;
    private final boolean isDoubleProperty;

    public NumberProperty(String name, int min, int max, int step) {
        super(name);
        this.spinner = new JSpinner(new SpinnerNumberModel(min, min, max, step));
        this.spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent pE) {
                NumberProperty.this.firePropertyChangeEvent();
            }
        });
        this.isDoubleProperty = false;
    }

    public NumberProperty(String name, double min, double max, double step) {
        super(name);
        this.spinner = new JSpinner(new SpinnerNumberModel(min, min, max, step));
        this.spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent pE) {
                NumberProperty.this.firePropertyChangeEvent();
            }
        });
        this.isDoubleProperty = true;
    }

    @Override
    public String getValue() {
        return this.spinner.getValue().toString();
    }

    @Override
    public void layout(DefaultFormBuilder builder) {
        this.layout(builder, this.spinner);
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.spinner.setEnabled(pEnabled);
    }

    @Override
    public void setValue(String value) {
        Number someValue;
        if (this.isDoubleProperty) {
            try {
                someValue = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                someValue = 1.0;
            }
        } else {
            try {
                someValue = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                someValue = 100;
            }
        }
        this.spinner.setValue(someValue);
    }

    public Number getNumberValue() {
        return (Number)this.spinner.getValue();
    }

    public void setValue(double value) {
        this.spinner.setValue(value);
    }

    public void setValue(int value) {
        this.spinner.setValue(value);
    }
}

