/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.PropertyBean;
import org.freeplane.core.util.TextUtils;

public class RemindValueProperty
extends PropertyBean
implements IPropertyControl {
    public static final String DON_T_TOUCH_VALUE = "";
    protected static final int DON_T_TOUCH_VALUE_INT = 2;
    public static final String FALSE_VALUE = "false";
    protected static final int FALSE_VALUE_INT = 1;
    public static final String TRUE_VALUE = "true";
    protected static final int TRUE_VALUE_INT = 0;
    JButton mButton = new JButton();
    int state = 0;

    public RemindValueProperty(String name) {
        super(name);
        this.mButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemindValueProperty.this.setState((RemindValueProperty.this.getState() + 1) % 3);
                RemindValueProperty.this.firePropertyChangeEvent();
            }
        });
    }

    private int getState() {
        return this.state;
    }

    @Override
    public String getValue() {
        switch (this.state) {
            case 0: {
                return TRUE_VALUE;
            }
            case 1: {
                return FALSE_VALUE;
            }
            case 2: {
                return DON_T_TOUCH_VALUE;
            }
        }
        return null;
    }

    @Override
    public void layout(DefaultFormBuilder builder) {
        this.layout(builder, this.mButton);
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.mButton.setEnabled(pEnabled);
    }

    protected void setState(int newState) {
        this.state = newState;
        String[] strings = new String[]{TextUtils.getText("OptionalDontShowMeAgainDialog.ok").replaceFirst("&", DON_T_TOUCH_VALUE), TextUtils.getText("OptionalDontShowMeAgainDialog.cancel").replaceFirst("&", DON_T_TOUCH_VALUE), TextUtils.getText("OptionPanel.ask").replaceFirst("&", DON_T_TOUCH_VALUE)};
        this.mButton.setText(strings[this.state]);
    }

    @Override
    public void setValue(String value) {
        if (value == null || !value.toLowerCase().equals(TRUE_VALUE) && !value.toLowerCase().equals(FALSE_VALUE) && !value.toLowerCase().equals(DON_T_TOUCH_VALUE)) {
            throw new IllegalArgumentException("Cannot set a boolean to " + value);
        }
        this.setState(this.transformString(value));
    }

    private int transformString(String string) {
        if (string == null) {
            return 2;
        }
        if (string.toLowerCase().equals(TRUE_VALUE)) {
            return 0;
        }
        if (string.toLowerCase().equals(FALSE_VALUE)) {
            return 1;
        }
        return 2;
    }
}

