/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

public class ColorTracker
implements ActionListener,
Serializable {
    static JColorChooser colorChooser = new JColorChooser();
    private static final long serialVersionUID = 1L;
    private final JColorChooser chooser;
    private Color color;

    public static JColorChooser getCommonJColorChooser() {
        return colorChooser;
    }

    public static Color showCommonJColorChooserDialog(Component component, String title, Color initialColor, final Color defaultColor) {
        JColorChooser pane = ColorTracker.getCommonJColorChooser();
        pane.setColor(initialColor);
        final ColorTracker ok = new ColorTracker(pane);
        final JDialog dialog = JColorChooser.createDialog(component, title, true, pane, ok, null);
        Container container = (Container)dialog.getContentPane().getComponent(1);
        if (defaultColor != null) {
            JButton defaultBtn = new JButton(TextUtils.getText("reset_to_default"));
            defaultBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.dispose();
                    ok.setColor(defaultColor);
                }
            });
            container.add(defaultBtn);
        }
        dialog.addWindowListener(new Closer());
        dialog.addComponentListener(new DisposeOnClose());
        dialog.pack();
        UITools.setDialogLocationRelativeTo(dialog, component);
        dialog.setVisible(true);
        return ok.getColor();
    }

    public static Color showCommonJColorChooserDialog(NodeModel nodeModel, String title, Color initialColor, Color defaultColor) throws HeadlessException {
        Controller controller = Controller.getCurrentController();
        Component component = controller.getMapViewManager().getComponent(nodeModel);
        return ColorTracker.showCommonJColorChooserDialog(component, title, initialColor, defaultColor);
    }

    ColorTracker(JColorChooser c) {
        this.chooser = c;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.color = this.chooser.getColor();
    }

    Color getColor() {
        return this.color;
    }

    protected void setColor(Color color) {
        this.color = color;
    }

    static class DisposeOnClose
    extends ComponentAdapter
    implements Serializable {
        private static final long serialVersionUID = 1L;

        DisposeOnClose() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            Window w = (Window)e.getComponent();
            w.dispose();
        }
    }

    static class Closer
    extends WindowAdapter
    implements Serializable {
        private static final long serialVersionUID = 1L;

        Closer() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            e.getWindow().setVisible(false);
            e.getWindow().dispose();
        }
    }
}

