/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import javax.swing.AbstractButton;
import javax.swing.JToolBar;
import org.freeplane.core.ui.components.ToolbarLayout;

public class FreeplaneToolBar
extends JToolBar {
    protected static Insets nullInsets = new Insets(0, 0, 0, 0);
    private static final long serialVersionUID = 1L;

    public FreeplaneToolBar(String name, int orientation) {
        super(name, orientation);
        this.setMargin(nullInsets);
        this.setFloatable(false);
        this.setRollover(true);
        if (orientation == 0) {
            super.setLayout(ToolbarLayout.getInstance());
            this.addHierarchyBoundsListener(new HierarchyBoundsListener(){

                @Override
                public void ancestorResized(HierarchyEvent e) {
                    FreeplaneToolBar.this.revalidate();
                    FreeplaneToolBar.this.repaint();
                }

                @Override
                public void ancestorMoved(HierarchyEvent e) {
                }
            });
        }
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (this.getOrientation() != 0) {
            super.setLayout(mgr);
        }
    }

    @Override
    public Component add(Component comp) {
        super.add(comp);
        this.configureComponent(comp);
        return comp;
    }

    @Override
    public Component add(Component comp, int index) {
        super.add(comp, index);
        this.configureComponent(comp);
        return comp;
    }

    @Override
    public void add(Component comp, Object constraints) {
        super.add(comp, constraints);
        this.configureComponent(comp);
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        super.add(comp, constraints, index);
        this.configureComponent(comp);
    }

    @Override
    public Component add(String name, Component comp) {
        super.add(name, comp);
        this.configureComponent(comp);
        return comp;
    }

    protected void configureComponent(Component comp) {
        if (!(comp instanceof AbstractButton)) {
            return;
        }
        AbstractButton abstractButton = (AbstractButton)comp;
        String actionName = (String)abstractButton.getAction().getValue("Name");
        abstractButton.setName(actionName);
        if (null != abstractButton.getIcon()) {
            String text = abstractButton.getText();
            String toolTipText = abstractButton.getToolTipText();
            if (text != null) {
                if (toolTipText == null) {
                    abstractButton.setToolTipText(text);
                }
                abstractButton.setText(null);
            }
        }
        if (System.getProperty("os.name").equals("Mac OS X")) {
            abstractButton.putClientProperty("JButton.buttonType", "segmented");
            abstractButton.putClientProperty("JButton.segmentPosition", "middle");
            Dimension buttonSize = new Dimension(22, 22);
            abstractButton.setPreferredSize(buttonSize);
            abstractButton.setFocusPainted(false);
        }
        abstractButton.setFocusable(false);
        abstractButton.setMargin(nullInsets);
    }
}

