/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.freeplane.core.ui.components.JResizer;
import org.freeplane.core.ui.components.ResizeEvent;
import org.freeplane.core.util.LogUtils;

public class OneTouchCollapseResizer
extends JResizer {
    private static final long serialVersionUID = 3836146387249880446L;
    public static final String COLLAPSED = OneTouchCollapseResizer.class.getPackage().getName() + ".collapsed";
    private static final String ALREADY_IN_PAINT = OneTouchCollapseResizer.class.getPackage().getName() + ".ALREADY_PAINTING";
    protected boolean expanded = true;
    private JPanel hotspot;
    private final int inset = 2;
    private final JResizer.Direction direction;
    private Integer resizeComponentIndex;
    private final Set<ComponentCollapseListener> collapseListener = new LinkedHashSet<ComponentCollapseListener>();

    public OneTouchCollapseResizer(final JResizer.Direction d) {
        super(d);
        this.direction = d;
        this.setDividerSize(7);
        MouseListener listener = new MouseListener(){

            private void resetCursor() {
                if (d.equals((Object)JResizer.Direction.RIGHT)) {
                    OneTouchCollapseResizer.this.setCursor(Cursor.getPredefinedCursor(10));
                } else if (d.equals((Object)JResizer.Direction.LEFT)) {
                    OneTouchCollapseResizer.this.setCursor(Cursor.getPredefinedCursor(11));
                } else if (d.equals((Object)JResizer.Direction.UP)) {
                    OneTouchCollapseResizer.this.setCursor(Cursor.getPredefinedCursor(9));
                } else {
                    OneTouchCollapseResizer.this.setCursor(Cursor.getPredefinedCursor(8));
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (e.getComponent() == OneTouchCollapseResizer.this.getHotSpot()) {
                    this.resetCursor();
                }
                if (OneTouchCollapseResizer.this.isExpanded()) {
                    this.resetCursor();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.getComponent() == OneTouchCollapseResizer.this.getHotSpot()) {
                    OneTouchCollapseResizer.this.getHotSpot().setCursor(Cursor.getPredefinedCursor(12));
                }
                if (!OneTouchCollapseResizer.this.isExpanded() || OneTouchCollapseResizer.this.sliderLock) {
                    e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getComponent() == OneTouchCollapseResizer.this.getHotSpot() || OneTouchCollapseResizer.this.sliderLock) {
                    if (OneTouchCollapseResizer.this.isExpanded()) {
                        OneTouchCollapseResizer.this.getHotSpot().setEnabled(true);
                        OneTouchCollapseResizer.this.setExpanded(false);
                    } else {
                        OneTouchCollapseResizer.this.setExpanded(true);
                    }
                } else if (!OneTouchCollapseResizer.this.isExpanded()) {
                    OneTouchCollapseResizer.this.setExpanded(true);
                }
            }
        };
        this.getHotSpot().addMouseListener(listener);
        this.addMouseListener(listener);
        this.add(this.getHotSpot());
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setDividerSize(int size) {
        int h;
        int w;
        if (this.direction.equals((Object)JResizer.Direction.RIGHT)) {
            w = size;
            h = 0;
        } else if (this.direction.equals((Object)JResizer.Direction.LEFT)) {
            h = 0;
            w = size;
        } else if (this.direction.equals((Object)JResizer.Direction.UP)) {
            h = size;
            w = 0;
        } else {
            h = size;
            w = 0;
        }
        this.setPreferredSize(new Dimension(w, h));
    }

    public int getDividerSize() {
        if (this.direction.equals((Object)JResizer.Direction.RIGHT) || this.direction.equals((Object)JResizer.Direction.LEFT)) {
            return this.getPreferredSize().width;
        }
        return this.getPreferredSize().height;
    }

    public void setExpanded(boolean enabled) {
        if (this.expanded != enabled) {
            this.expanded = enabled;
            try {
                Component resizedComponent = this.getResizedComponent();
                if (resizedComponent instanceof JComponent) {
                    ((JComponent)resizedComponent).putClientProperty(COLLAPSED, enabled ? null : "true");
                }
                if (enabled) {
                    resizedComponent.setPreferredSize(null);
                } else {
                    resizedComponent.setPreferredSize(new Dimension(0, 0));
                }
                this.fireCollapseStateChanged(resizedComponent, enabled);
                this.recalibrate();
            }
            catch (Exception e) {
                LogUtils.warn("Exception in org.freeplane.core.ui.components.OneTouchCollapseResizer.setExpanded(enabled): " + e);
            }
        }
    }

    private Component getResizedComponent() {
        JComponent parent = (JComponent)this.getParent();
        if (parent != null && this.resizeComponentIndex == null) {
            this.resizeComponentIndex = this.getIndex();
        }
        return parent.getComponent(this.resizeComponentIndex);
    }

    @Override
    public void paint(Graphics g) {
        if (this.getClientProperty(ALREADY_IN_PAINT) != null) {
            return;
        }
        this.putClientProperty(ALREADY_IN_PAINT, "true");
        super.paint(g);
        if (this.direction.equals((Object)JResizer.Direction.RIGHT) || this.direction.equals((Object)JResizer.Direction.LEFT)) {
            int center_y = this.getHeight() / 2;
            int divSize = this.getDividerSize();
            this.getHotSpot().setBounds(0, center_y - 15, divSize, 30);
        } else {
            int center_x = this.getWidth() / 2;
            int divSize = this.getDividerSize();
            this.getHotSpot().setBounds(center_x - 15, 0, 30, divSize);
        }
        Dimension size = this.getResizedComponent().getPreferredSize();
        if ((this.direction.equals((Object)JResizer.Direction.RIGHT) || this.direction.equals((Object)JResizer.Direction.LEFT)) && size.width <= this.getDividerSize()) {
            this.setExpanded(false);
        } else if ((this.direction.equals((Object)JResizer.Direction.UP) || this.direction.equals((Object)JResizer.Direction.DOWN)) && size.height <= this.getDividerSize()) {
            this.setExpanded(false);
        } else {
            this.setExpanded(true);
        }
        if (this.getResizedComponent() instanceof JComponent) {
            ((JComponent)this.getResizedComponent()).putClientProperty(COLLAPSED, this.isExpanded() ? null : "true");
        }
        this.getHotSpot().paint(g.create(this.getHotSpot().getLocation().x, this.getHotSpot().getLocation().y, this.getHotSpot().getWidth(), this.getHotSpot().getHeight()));
        this.putClientProperty(ALREADY_IN_PAINT, null);
    }

    private Component getHotSpot() {
        if (this.hotspot == null) {
            this.hotspot = new JPanel(){
                private static final long serialVersionUID = -5321517835206976034L;

                @Override
                public void paint(Graphics g) {
                    if (OneTouchCollapseResizer.this.isExpanded()) {
                        OneTouchCollapseResizer.this.drawCollapseLabel(g);
                    } else {
                        OneTouchCollapseResizer.this.drawExpandLabel(g);
                    }
                }

                @Override
                public void updateUI() {
                    try {
                        super.updateUI();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            this.hotspot.setBackground(Color.BLUE);
        }
        return this.hotspot;
    }

    private void drawCollapseLabel(Graphics g) {
        Dimension size = g.getClipBounds().getSize();
        int half_length = Math.round((float)size.height * 0.2f);
        int center_y = size.height / 2;
        int half_width = Math.round((float)size.width * 0.2f);
        int center_x = size.width / 2;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.direction.equals((Object)JResizer.Direction.LEFT)) {
            this.arrowLeft(g, half_length, center_y);
        } else if (this.direction.equals((Object)JResizer.Direction.RIGHT)) {
            this.arrowRight(g, half_length, center_y);
        } else if (this.direction.equals((Object)JResizer.Direction.UP)) {
            this.arrowUp(g, half_width, center_x);
        } else if (this.direction.equals((Object)JResizer.Direction.DOWN)) {
            this.arrowDown(g, half_width, center_x);
        }
    }

    private void drawExpandLabel(Graphics g) {
        Dimension size = g.getClipBounds().getSize();
        int half_length = (size.height - 12) / 2;
        int center_y = size.height / 2;
        int half_width = (size.width - 12) / 2;
        int center_x = size.width / 2;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.direction.equals((Object)JResizer.Direction.LEFT)) {
            this.arrowRight(g, half_length, center_y);
        } else if (this.direction.equals((Object)JResizer.Direction.RIGHT)) {
            this.arrowLeft(g, half_length, center_y);
        } else if (this.direction.equals((Object)JResizer.Direction.UP)) {
            this.arrowDown(g, half_width, center_x);
        } else if (this.direction.equals((Object)JResizer.Direction.DOWN)) {
            this.arrowUp(g, half_width, center_x);
        }
    }

    private void arrowLeft(Graphics g, int half_length, int center_y) {
        int[] x = new int[]{2, this.getSize().width - 2, this.getSize().width - 2};
        int[] y = new int[]{center_y, center_y - half_length, center_y + half_length};
        g.setColor(Color.DARK_GRAY);
        g.fillPolygon(x, y, 3);
        g.setColor(Color.DARK_GRAY);
        g.drawLine(2, center_y, this.getSize().width - 2, center_y - half_length);
        g.setColor(Color.GRAY);
        g.drawLine(this.getSize().width - 2, center_y + half_length, 2, center_y);
        g.setColor(Color.GRAY);
        g.drawLine(this.getSize().width - 2, center_y - half_length, this.getSize().width - 2, center_y + half_length);
    }

    private void arrowRight(Graphics g, int half_length, int center_y) {
        int[] x = new int[]{2, 2, this.getSize().width - 2};
        int[] y = new int[]{center_y + half_length, center_y - half_length, center_y};
        g.setColor(Color.DARK_GRAY);
        g.fillPolygon(x, y, 3);
        g.setColor(Color.DARK_GRAY);
        g.drawLine(2, center_y + half_length, 2, center_y - half_length);
        g.setColor(Color.GRAY);
        g.drawLine(2, center_y - half_length, this.getSize().width - 2, center_y);
        g.setColor(Color.LIGHT_GRAY);
        g.drawLine(this.getSize().width - 2, center_y, 2, center_y + half_length);
    }

    private void arrowUp(Graphics g, int half_length, int center_x) {
        int[] y = new int[]{2, this.getSize().height - 2, this.getSize().height - 2};
        int[] x = new int[]{center_x, center_x - half_length, center_x + half_length};
        g.setColor(Color.DARK_GRAY);
        g.fillPolygon(x, y, 3);
        g.setColor(Color.GRAY);
        g.drawLine(center_x + half_length, this.getSize().height - 2, center_x, 2);
        g.setColor(Color.DARK_GRAY);
        g.drawLine(center_x, 2, center_x - half_length, this.getSize().height - 2);
        g.setColor(Color.LIGHT_GRAY);
        g.drawLine(center_x - half_length, this.getSize().height - 2, center_x + half_length, this.getSize().height - 2);
    }

    private void arrowDown(Graphics g, int half_length, int center_x) {
        int[] y = new int[]{2, 2, this.getSize().height - 2};
        int[] x = new int[]{center_x + half_length, center_x - half_length, center_x};
        g.setColor(Color.DARK_GRAY);
        g.fillPolygon(x, y, 3);
        g.setColor(Color.GRAY);
        g.drawLine(center_x - half_length, 2, center_x, this.getSize().height - 2);
        g.setColor(Color.DARK_GRAY);
        g.drawLine(center_x + half_length, 2, center_x - half_length, 2);
        g.setColor(Color.LIGHT_GRAY);
        g.drawLine(center_x, this.getSize().height - 2, center_x + half_length, 2);
    }

    private int getIndex() {
        Container parent = this.getParent();
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            if (!this.equals(parent.getComponent(i))) continue;
            if (this.direction.equals((Object)JResizer.Direction.RIGHT)) {
                return i + 1;
            }
            if (this.direction.equals((Object)JResizer.Direction.LEFT)) {
                return i - 1;
            }
            if (this.direction.equals((Object)JResizer.Direction.UP)) {
                return i - 1;
            }
            if (!this.direction.equals((Object)JResizer.Direction.DOWN)) continue;
            return i + 1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCollapseListener(ComponentCollapseListener listener) {
        if (listener == null) {
            return;
        }
        Set<ComponentCollapseListener> set = this.collapseListener;
        synchronized (set) {
            this.collapseListener.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCollapseListener(ComponentCollapseListener listener) {
        if (listener == null) {
            return;
        }
        Set<ComponentCollapseListener> set = this.collapseListener;
        synchronized (set) {
            this.collapseListener.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCollapseStateChanged(Component resizedComponent, boolean expanded) {
        ResizeEvent event = new ResizeEvent(this, resizedComponent);
        Set<ComponentCollapseListener> set = this.collapseListener;
        synchronized (set) {
            for (ComponentCollapseListener listener : this.collapseListener) {
                try {
                    if (expanded) {
                        listener.componentExpanded(event);
                        continue;
                    }
                    listener.componentCollapsed(event);
                }
                catch (Exception e) {
                    LogUtils.severe(e);
                }
            }
        }
    }

    public static OneTouchCollapseResizer findResizerFor(Component component) {
        if (component instanceof Container) {
            Component[] children;
            for (Component child : children = ((Container)component).getComponents()) {
                if (!(child instanceof OneTouchCollapseResizer)) continue;
                return (OneTouchCollapseResizer)child;
            }
        }
        if (component == null) {
            return null;
        }
        Container parent = component.getParent();
        return OneTouchCollapseResizer.findResizerFor(parent);
    }

    public void recalibrate() {
        JComponent parent;
        if (this.getClientProperty(ALREADY_IN_PAINT) == null && (parent = (JComponent)this.getParent()) != null) {
            parent.revalidate();
            parent.repaint();
        }
    }

    public static interface ComponentCollapseListener {
        public void componentCollapsed(ResizeEvent var1);

        public void componentExpanded(ResizeEvent var1);
    }
}

