/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components.html;

import java.awt.Color;
import java.awt.Font;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.Quantity;

public class CssRuleBuilder {
    private StringBuilder rule = new StringBuilder();

    public String buildRule() {
        return this.rule.toString();
    }

    public CssRuleBuilder withFont(Font font) {
        return this.withFont(font, 1.0f);
    }

    public CssRuleBuilder withFont(Font font, float fontScaleFactor) {
        if (font != null) {
            this.rule.append(" font-family: ");
            this.rule.append(font.getFamily());
            this.rule.append("; ");
            this.rule.append(" font-size: ");
            int fontSize = Math.round((float)font.getSize() / fontScaleFactor);
            this.rule.append(fontSize);
            this.rule.append("pt;");
            if (font.isBold()) {
                this.rule.append(" font-weight: bold;");
            }
            if (font.isItalic()) {
                this.rule.append(" font-style: italic;");
            }
        }
        return this;
    }

    public CssRuleBuilder withColor(Color color) {
        if (color != null) {
            this.rule.append("color: ").append(ColorUtils.colorToString(color)).append(";");
        }
        return this;
    }

    public CssRuleBuilder withBackground(Color color) {
        if (color != null) {
            this.rule.append("background-color: ").append(ColorUtils.colorToString(color)).append(";");
        }
        return this;
    }

    public CssRuleBuilder withAlignment(int alignment) {
        switch (alignment) {
            case 0: {
                this.rule.append("text-align: center;");
                break;
            }
            case 2: {
                this.rule.append("text-align: left;");
                break;
            }
            case 4: {
                this.rule.append("text-align: right;");
                break;
            }
        }
        return this;
    }

    public String toString() {
        return this.rule.toString();
    }

    public CssRuleBuilder withMaxWidthAsPt(Quantity<?> ... widths) {
        int maxBaseUnits = -1;
        for (Quantity<?> width : widths) {
            if (width == null) continue;
            maxBaseUnits = Math.max(maxBaseUnits, width.toBaseUnitsRounded());
        }
        if (maxBaseUnits >= 0) {
            this.rule.append("width: ").append(maxBaseUnits).append("pt").append(";");
        }
        return this;
    }
}

