/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.factory.MindIconFactory;
import org.freeplane.features.icon.mindmapmode.MIconController;

public class FreeplaneIconUtils {
    public static Icon createStandardIcon(String iconKey) {
        return MindIconFactory.create(iconKey).getIcon();
    }

    public static List<String> listStandardIconKeys() {
        ArrayList<String> result = new ArrayList<String>();
        MIconController mIconController = (MIconController)IconController.getController();
        for (MindIcon mindIcon : mIconController.getMindIcons()) {
            result.add(mindIcon.getName());
        }
        return result;
    }

    public static ImageIcon createImageIcon(String resourcePath) {
        URL resourceUrl = ResourceController.getResourceController().getResource(resourcePath);
        return FreeplaneIconUtils.createImageIcon(resourceUrl);
    }

    public static ImageIcon createImageIconByResourceKey(String resourceKey) {
        ResourceController resourceController = ResourceController.getResourceController();
        URL resourceUrl = resourceController.getResource(resourceController.getProperty(resourceKey));
        return FreeplaneIconUtils.createImageIcon(resourceUrl);
    }

    public static ImageIcon createImageIconPrivileged(final URL resourceUrl) {
        return AccessController.doPrivileged(new PrivilegedAction<ImageIcon>(){

            @Override
            public ImageIcon run() {
                return FreeplaneIconUtils.createImageIcon(resourceUrl);
            }
        });
    }

    private static ImageIcon createImageIcon(URL resourceUrl) {
        return new ImageIcon(resourceUrl);
    }
}

