/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import org.freeplane.core.io.xml.TreeXmlReader;
import org.freeplane.core.io.xml.TreeXmlWriter;
import org.freeplane.core.util.TypeReference;
import org.freeplane.features.attribute.AttributeConditionController;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.CompareConditionAdapter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.text.TextController;
import org.freeplane.n3.nanoxml.XMLElement;

public class AttributeCompareCondition
extends CompareConditionAdapter {
    static final String ATTRIBUTE = "ATTRIBUTE";
    static final String COMPARATION_RESULT = "COMPARATION_RESULT";
    static final String NAME = "attribute_compare_condition";
    static final String SUCCEED = "SUCCEED";
    private final Object attribute;
    private final int comparationResult;
    private final boolean succeed;

    static ASelectableCondition load(XMLElement element) {
        Object attr = AttributeConditionController.toAttributeObject(element.getAttribute(ATTRIBUTE, null));
        Object value = element.getAttribute("VALUE", null);
        if (value == null) {
            String spec = element.getAttribute("OBJECT", null);
            value = TypeReference.create(spec);
        }
        boolean matchCase = TreeXmlReader.xmlToBoolean(element.getAttribute("MATCH_CASE", null));
        int compResult = Integer.parseInt(element.getAttribute(COMPARATION_RESULT, null));
        boolean succeed = TreeXmlReader.xmlToBoolean(element.getAttribute(SUCCEED, null));
        boolean matchApproximately = TreeXmlReader.xmlToBoolean(element.getAttribute("MATCH_APPROXIMATELY", null));
        return new AttributeCompareCondition(attr, value, matchCase, compResult, succeed, matchApproximately);
    }

    public AttributeCompareCondition(Object attribute, Object value, boolean matchCase, int comparationResult, boolean succeed, boolean matchApproximately) {
        super(value, matchCase, matchApproximately);
        this.attribute = attribute;
        this.comparationResult = comparationResult;
        this.succeed = succeed;
    }

    @Override
    public boolean isEqualityCondition() {
        return this.comparationResult == 0;
    }

    @Override
    public boolean checkNode(NodeModel node) {
        NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel(node);
        TextController textController = TextController.getController();
        for (int i = 0; i < attributes.getRowCount(); ++i) {
            Object originalContent;
            Object content;
            if (this.attribute.equals(AttributeConditionController.ANY_ATTRIBUTE_NAME_OR_VALUE_OBJECT)) {
                if (this.checkContent(attributes.getValueAt(i, 0))) {
                    return true;
                }
            } else if (!attributes.getValueAt(i, 0).equals(this.attribute)) continue;
            if (!this.checkContent(content = textController.getTransformedObjectNoThrow(originalContent = attributes.getValueAt(i, 1), node, null))) continue;
            return true;
        }
        return false;
    }

    private boolean checkContent(Object content) {
        this.compareTo(content);
        return this.isComparisonOK() && this.succeed == (this.getComparisonResult() == this.comparationResult);
    }

    @Override
    protected String createDescription() {
        return super.createDescription(this.attribute.toString(), this.comparationResult, this.succeed);
    }

    @Override
    public void fillXML(XMLElement child) {
        super.fillXML(child);
        if (this.attribute instanceof String) {
            child.setAttribute(ATTRIBUTE, (String)this.attribute);
        }
        child.setAttribute(COMPARATION_RESULT, Integer.toString(this.comparationResult));
        child.setAttribute(SUCCEED, TreeXmlWriter.BooleanToXml(this.succeed));
        child.setAttribute("MATCH_APPROXIMATELY", TreeXmlWriter.BooleanToXml(this.matchApproximately));
    }

    @Override
    protected String getName() {
        return NAME;
    }
}

