/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import org.freeplane.core.extension.IExtension;
import org.freeplane.features.attribute.AttributeConditionController;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.attribute.HideAllAttributesAction;
import org.freeplane.features.attribute.ShowAllAttributesAction;
import org.freeplane.features.attribute.ShowSelectedAttributesAction;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;

public class ModelessAttributeController
implements IExtension {
    public static final String ATTRIBUTE_VIEW_TYPE = "AttributeViewType";

    public static ModelessAttributeController getController() {
        Controller controller = Controller.getCurrentController();
        return controller.getExtension(ModelessAttributeController.class);
    }

    public static void install() {
        Controller controller = Controller.getCurrentController();
        controller.addExtension(ModelessAttributeController.class, new ModelessAttributeController());
        FilterController.getCurrentFilterController().getConditionFactory().addConditionController(1000, new AttributeConditionController());
    }

    public ModelessAttributeController() {
        Controller controller = Controller.getCurrentController();
        ShowAllAttributesAction showAllAttributes = new ShowAllAttributesAction();
        ShowSelectedAttributesAction showSelectedAttributes = new ShowSelectedAttributesAction();
        HideAllAttributesAction hideAllAttributes = new HideAllAttributesAction();
        controller.addAction(showAllAttributes);
        controller.addAction(showSelectedAttributes);
        controller.addAction(hideAllAttributes);
    }

    protected void setAttributeViewType(MapModel map, String type) {
        String attributeViewType = this.getAttributeViewType(map);
        if (attributeViewType != null && attributeViewType != type) {
            AttributeRegistry attributes = AttributeRegistry.getRegistry(map);
            attributes.setAttributeViewType(type);
            MapChangeEvent mapChangeEvent = new MapChangeEvent(this, map, ATTRIBUTE_VIEW_TYPE, attributeViewType, type);
            Controller.getCurrentModeController().getMapController().fireMapChanged(mapChangeEvent);
        }
    }

    protected String getAttributeViewType(MapModel map) {
        if (map == null) {
            return null;
        }
        AttributeRegistry attributes = AttributeRegistry.getRegistry(map);
        if (attributes == null) {
            return null;
        }
        String attributeViewType = attributes.getAttributeViewType();
        return attributeViewType;
    }
}

