/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.edge;

import java.awt.Color;
import java.util.Collection;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.util.ConstantObject;
import org.freeplane.core.util.ObjectRule;
import org.freeplane.core.util.RuleReference;
import org.freeplane.features.edge.AutomaticEdgeColor;
import org.freeplane.features.edge.EdgeBuilder;
import org.freeplane.features.edge.EdgeModel;
import org.freeplane.features.edge.EdgeStyle;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ExclusivePropertyChain;
import org.freeplane.features.mode.IPropertyHandler;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.AutomaticLayoutController;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;

public class EdgeController
implements IExtension {
    public static final EdgeStyle STANDARD_EDGE_STYLE = EdgeStyle.EDGESTYLE_BEZIER;
    public static final Color STANDARD_EDGE_COLOR = new Color(Color.GRAY.getRGB());
    private final ExclusivePropertyChain<ObjectRule<Color, Rules>, NodeModel> colorHandlers;
    private final ExclusivePropertyChain<EdgeStyle, NodeModel> styleHandlers;
    private final ExclusivePropertyChain<Integer, NodeModel> widthHandlers;
    private ModeController modeController;

    public static EdgeController getController() {
        return EdgeController.getController(Controller.getCurrentModeController());
    }

    public static EdgeController getController(ModeController modeController) {
        return modeController.getExtension(EdgeController.class);
    }

    public static void install(EdgeController edgeController) {
        Controller.getCurrentModeController().addExtension(EdgeController.class, edgeController);
    }

    public EdgeController(final ModeController modeController) {
        this.modeController = modeController;
        this.colorHandlers = new ExclusivePropertyChain();
        this.styleHandlers = new ExclusivePropertyChain();
        this.widthHandlers = new ExclusivePropertyChain();
        this.addColorGetter(IPropertyHandler.NODE, new IPropertyHandler<ObjectRule<Color, Rules>, NodeModel>(){

            @Override
            public ObjectRule<Color, Rules> getProperty(NodeModel node, ObjectRule<Color, Rules> currentValue) {
                return EdgeController.this.getStyleEdgeColorRule(node);
            }
        });
        this.addColorGetter(IPropertyHandler.AUTO, new IPropertyHandler<ObjectRule<Color, Rules>, NodeModel>(){

            @Override
            public ObjectRule<Color, Rules> getProperty(NodeModel model, ObjectRule<Color, Rules> currentValue) {
                MapModel map = model.getMap();
                AutomaticEdgeColor layout = map.getRootNode().getExtension(AutomaticEdgeColor.class);
                if (layout != null) {
                    switch (layout.rule) {
                        case FOR_COLUMNS: {
                            return new RuleReference<Color, Rules>(Rules.BY_COLUMN);
                        }
                        case FOR_LEVELS: {
                            return new RuleReference<Color, Rules>(Rules.BY_LEVEL);
                        }
                        case FOR_BRANCHES: {
                            NodeModel parentNode = model.getParentNode();
                            if (parentNode == null || !parentNode.isRoot()) break;
                            return new RuleReference<Color, Rules>(Rules.BY_BRANCH);
                        }
                    }
                }
                return null;
            }
        });
        this.addColorGetter(IPropertyHandler.DEFAULT, new IPropertyHandler<ObjectRule<Color, Rules>, NodeModel>(){

            @Override
            public ObjectRule<Color, Rules> getProperty(NodeModel node, ObjectRule<Color, Rules> currentValue) {
                return new RuleReference<Color, Rules>(Rules.BY_PARENT);
            }
        });
        this.addStyleGetter(IPropertyHandler.STYLE, new IPropertyHandler<EdgeStyle, NodeModel>(){

            @Override
            public EdgeStyle getProperty(NodeModel node, EdgeStyle currentValu) {
                return EdgeController.this.getStyleStyle(node.getMap(), LogicalStyleController.getController(modeController).getStyles(node));
            }
        });
        this.addStyleGetter(IPropertyHandler.DEFAULT, new IPropertyHandler<EdgeStyle, NodeModel>(){

            @Override
            public EdgeStyle getProperty(NodeModel node, EdgeStyle currentValue) {
                if (node.getParentNode() != null) {
                    return null;
                }
                return STANDARD_EDGE_STYLE;
            }
        });
        this.addWidthGetter(IPropertyHandler.STYLE, new IPropertyHandler<Integer, NodeModel>(){

            @Override
            public Integer getProperty(NodeModel node, Integer currentValue) {
                return EdgeController.this.getStyleWidth(node.getMap(), LogicalStyleController.getController(modeController).getStyles(node));
            }
        });
        this.addWidthGetter(IPropertyHandler.DEFAULT, new IPropertyHandler<Integer, NodeModel>(){

            @Override
            public Integer getProperty(NodeModel node, Integer currentValue) {
                if (node.getParentNode() != null) {
                    return null;
                }
                return new Integer(0);
            }
        });
        MapController mapController = Controller.getCurrentModeController().getMapController();
        ReadManager readManager = mapController.getReadManager();
        WriteManager writeManager = mapController.getWriteManager();
        EdgeBuilder edgeBuilder = new EdgeBuilder(this);
        edgeBuilder.registerBy(readManager, writeManager);
    }

    public IPropertyHandler<ObjectRule<Color, Rules>, NodeModel> addColorGetter(Integer key, IPropertyHandler<ObjectRule<Color, Rules>, NodeModel> getter) {
        return this.colorHandlers.addGetter(key, getter);
    }

    public IPropertyHandler<EdgeStyle, NodeModel> addStyleGetter(Integer key, IPropertyHandler<EdgeStyle, NodeModel> getter) {
        return this.styleHandlers.addGetter(key, getter);
    }

    public IPropertyHandler<Integer, NodeModel> addWidthGetter(Integer key, IPropertyHandler<Integer, NodeModel> getter) {
        return this.widthHandlers.addGetter(key, getter);
    }

    public Color getColor(NodeModel node) {
        return this.getColor(node, true);
    }

    public Color getColor(NodeModel node, boolean resolveColor) {
        NodeModel parentNode;
        ObjectRule<Color, Rules> colorRule = this.getColorRule(node);
        if (colorRule.hasValue()) {
            return colorRule.getValue();
        }
        if (Rules.BY_PARENT == colorRule.getRule() && (parentNode = node.getParentNode()) != null) {
            return this.getColor(parentNode);
        }
        return STANDARD_EDGE_COLOR;
    }

    public ObjectRule<Color, Rules> getColorRule(NodeModel node) {
        ObjectRule<Color, Rules> color = this.colorHandlers.getProperty(node);
        return color;
    }

    public EdgeStyle getStyle(NodeModel node) {
        return this.getStyle(node, true);
    }

    public EdgeStyle getStyle(NodeModel node, boolean resolveParent) {
        EdgeStyle style = this.styleHandlers.getProperty(node);
        if (style == null && resolveParent) {
            return this.getStyle(node.getParentNode());
        }
        return style;
    }

    public int getWidth(NodeModel node) {
        return this.getWidth(node, true);
    }

    public Integer getWidth(NodeModel node, boolean resolveParent) {
        Integer width = this.widthHandlers.getProperty(node);
        if (width == null && resolveParent) {
            return this.getWidth(node.getParentNode());
        }
        return width;
    }

    private ObjectRule<Color, Rules> getStyleEdgeColorRule(NodeModel node) {
        MapModel map = node.getMap();
        Collection<IStyle> collection = LogicalStyleController.getController(this.modeController).getStyles(node);
        MapStyleModel styles = MapStyleModel.getExtension(map);
        for (IStyle styleKey : collection) {
            ObjectRule<Color, Rules> nodeColor;
            AutomaticLayoutController automaticLayoutController;
            NodeModel styleNode = styles.getStyleNode(styleKey);
            if (styleNode == null || node != styleNode && map.getRootNode().containsExtension(AutomaticEdgeColor.class) && (automaticLayoutController = this.modeController.getExtension(AutomaticLayoutController.class)) != null && automaticLayoutController.isAutomaticLevelStyle(styleNode) || (nodeColor = this.getNodeColorRule(styleNode)) == null) continue;
            return nodeColor;
        }
        return null;
    }

    private Integer getStyleWidth(MapModel map, Collection<IStyle> collection) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : collection) {
            int width;
            EdgeModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = EdgeModel.getModel(styleNode)) == null || (width = styleModel.getWidth()) == -1) continue;
            return width;
        }
        return null;
    }

    private EdgeStyle getStyleStyle(MapModel map, Collection<IStyle> collection) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : collection) {
            EdgeStyle style;
            EdgeModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = EdgeModel.getModel(styleNode)) == null || (style = styleModel.getStyle()) == null) continue;
            return style;
        }
        return null;
    }

    private ObjectRule<Color, Rules> getNodeColorRule(NodeModel styleNode) {
        EdgeModel styleModel = EdgeModel.getModel(styleNode);
        if (styleModel == null) {
            return null;
        }
        Color styleColor = styleModel.getColor();
        if (styleColor == null) {
            return null;
        }
        return new ConstantObject<Color, Rules>(styleColor);
    }

    public static enum Rules {
        BY_PARENT,
        BY_COLUMN,
        BY_LEVEL,
        BY_BRANCH;

    }
}

