/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.icon.IStateIconProvider;
import org.freeplane.features.icon.IconBuilder;
import org.freeplane.features.icon.IconClickedEvent;
import org.freeplane.features.icon.IconConditionController;
import org.freeplane.features.icon.IconMouseListener;
import org.freeplane.features.icon.IconRegistry;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.PriorityConditionController;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.CombinedPropertyChain;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.IPropertyHandler;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.StyleNode;

public class IconController
implements IExtension {
    private final CombinedPropertyChain<Collection<MindIcon>, NodeModel> iconHandlers;
    private final Collection<IStateIconProvider> stateIconProviders = new LinkedList<IStateIconProvider>();
    private final List<IconMouseListener> iconMouseListeners;

    public static IconController getController() {
        ModeController modeController = Controller.getCurrentModeController();
        return IconController.getController(modeController);
    }

    public static IconController getController(ModeController modeController) {
        return modeController.getExtension(IconController.class);
    }

    public static void install() {
        ConditionFactory conditionFactory = FilterController.getCurrentFilterController().getConditionFactory();
        conditionFactory.addConditionController(10, new IconConditionController());
        conditionFactory.addConditionController(50, new PriorityConditionController());
    }

    public static void install(IconController iconController) {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addExtension(IconController.class, iconController);
    }

    public void addIconMouseListener(IconMouseListener iconMouseListener) {
        this.iconMouseListeners.add(iconMouseListener);
    }

    public boolean addStateIconProvider(IStateIconProvider o) {
        return this.stateIconProviders.add(o);
    }

    public boolean removeStateIconProvider(IStateIconProvider o) {
        return this.stateIconProviders.remove(o);
    }

    public IconController(final ModeController modeController) {
        this.iconHandlers = new CombinedPropertyChain(false);
        MapController mapController = modeController.getMapController();
        ReadManager readManager = mapController.getReadManager();
        WriteManager writeManager = mapController.getWriteManager();
        IconBuilder textBuilder = new IconBuilder(this, IconStoreFactory.create());
        textBuilder.registerBy(readManager, writeManager);
        this.addIconGetter(IPropertyHandler.STYLE, new IPropertyHandler<Collection<MindIcon>, NodeModel>(){

            @Override
            public Collection<MindIcon> getProperty(NodeModel node, Collection<MindIcon> currentValue) {
                MapStyleModel model = MapStyleModel.getExtension(node.getMap());
                Collection<IStyle> styleKeys = LogicalStyleController.getController(modeController).getStyles(node);
                for (IStyle styleKey : styleKeys) {
                    NodeModel styleNode = model.getStyleNode(styleKey);
                    if (styleNode == null || node == styleNode && !(styleKey instanceof StyleNode)) continue;
                    List<MindIcon> styleIcons = styleNode.getIcons();
                    currentValue.addAll(styleIcons);
                }
                return currentValue;
            }
        });
        this.iconMouseListeners = new LinkedList<IconMouseListener>();
    }

    public IPropertyHandler<Collection<MindIcon>, NodeModel> addIconGetter(Integer key, IPropertyHandler<Collection<MindIcon>, NodeModel> getter) {
        return this.iconHandlers.addGetter(key, getter);
    }

    public IPropertyHandler<Collection<MindIcon>, NodeModel> removeIconGetter(Integer key, IPropertyHandler<Collection<MindIcon>, NodeModel> getter) {
        return this.iconHandlers.addGetter(key, getter);
    }

    public Collection<MindIcon> getIcons(NodeModel node) {
        Collection icons = this.iconHandlers.getProperty(node, new LinkedList());
        return icons;
    }

    public final Collection<UIIcon> getStateIcons(NodeModel node) {
        LinkedList<UIIcon> icons = new LinkedList<UIIcon>();
        for (IStateIconProvider provider : this.stateIconProviders) {
            UIIcon stateIcon = provider.getStateIcon(node);
            if (stateIcon == null) continue;
            icons.add(stateIcon);
            IconRegistry iconRegistry = node.getMap().getIconRegistry();
            iconRegistry.addIcon(stateIcon);
        }
        return icons;
    }

    public boolean onIconClicked(NodeModel node, UIIcon icon) {
        boolean processed = false;
        for (IconMouseListener listener : this.iconMouseListeners) {
            IconClickedEvent event;
            if (!listener.onIconClicked(event = new IconClickedEvent(icon, node))) continue;
            processed = true;
        }
        return processed;
    }
}

