/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.UIIcon;

public class IconGroup {
    private String name;
    private List<MindIcon> icons;
    private UIIcon groupIcon;
    private String description;

    public IconGroup(String name, UIIcon groupIcon) {
        this.name = name;
        this.groupIcon = groupIcon;
    }

    public IconGroup(String name, UIIcon groupIcon, String description) {
        this.name = name;
        this.groupIcon = groupIcon;
        this.description = description;
    }

    public IconGroup(String name, UIIcon groupIcon, String description, List<MindIcon> icons) {
        this.name = name;
        this.groupIcon = groupIcon;
        this.description = description;
        this.icons = new ArrayList<MindIcon>(icons);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<MindIcon> getIcons() {
        return Collections.unmodifiableList(this.icons);
    }

    public void setIcons(List<MindIcon> icons) {
        this.icons = new ArrayList<MindIcon>(icons);
    }

    public UIIcon getGroupIcon() {
        return this.groupIcon;
    }

    public void setGroupIcon(UIIcon groupIcon) {
        this.groupIcon = groupIcon;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = TextUtils.getText(this.getDescriptionKey());
        }
        return this.description;
    }

    public String getDescriptionKey() {
        return "IconGroupPopupAction." + this.name.toLowerCase() + ".text";
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addIcon(MindIcon icon) {
        this.icons.add(icon);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IconGroup other = (IconGroup)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return String.format("icon group [%s]", this.name);
    }
}

