/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.awt.Color;
import java.awt.Point;
import org.freeplane.features.link.ArrowType;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.map.NodeModel;

class ConnectorProperties {
    private Color color;
    private int alpha;
    private ArrowType endArrow;
    private int[] dash;
    private Point endInclination;
    private String middleLabel;
    private String sourceLabel;
    private ArrowType startArrow;
    private Point startInclination;
    private String targetLabel;
    private int width;
    private ConnectorModel.Shape shape;
    private String labelFontFamily;
    private int labelFontSize;
    private boolean showControlPointsFlag;

    public ConnectorProperties(Color color, int alpha, ConnectorModel.Shape shape, int width, String labelFontFamily, int labelFontSize) {
        assert (color != null);
        assert (shape != null);
        this.color = color;
        this.setAlpha(alpha);
        this.width = width;
        this.shape = shape;
        this.labelFontFamily = labelFontFamily;
        this.labelFontSize = labelFontSize;
        this.startArrow = ArrowType.NONE;
        this.endArrow = ArrowType.DEFAULT;
    }

    public ConnectorModel.Shape getShape() {
        return this.shape;
    }

    public void setShape(ConnectorModel.Shape shape) {
        assert (shape != null);
        this.shape = shape;
    }

    public int[] getDash() {
        return this.dash;
    }

    public void setDash(int[] dash) {
        this.dash = dash;
    }

    public Color getColor() {
        return this.color;
    }

    public ArrowType getEndArrow() {
        return this.endArrow;
    }

    public Point getEndInclination() {
        if (this.endInclination == null) {
            return null;
        }
        return new Point(this.endInclination);
    }

    public String getMiddleLabel() {
        return this.middleLabel;
    }

    public String getSourceLabel() {
        return this.sourceLabel;
    }

    public ArrowType getStartArrow() {
        return this.startArrow;
    }

    public Point getStartInclination() {
        if (this.startInclination == null) {
            return null;
        }
        return new Point(this.startInclination);
    }

    public String getTargetLabel() {
        return this.targetLabel;
    }

    public int getWidth() {
        return this.width;
    }

    public void setColor(Color color) {
        assert (color != null);
        this.color = color;
    }

    public void setEndArrow(ArrowType endArrow) {
        assert (endArrow != null);
        this.endArrow = endArrow;
    }

    public void setEndInclination(Point endInclination) {
        assert (endInclination != null);
        this.endInclination = endInclination;
    }

    public void setMiddleLabel(String middleLabel) {
        this.middleLabel = this.empty2null(middleLabel);
    }

    public boolean getShowControlPointsFlag() {
        return this.showControlPointsFlag;
    }

    public void setShowControlPoints(boolean bShowControlPointsFlag) {
        this.showControlPointsFlag = bShowControlPointsFlag;
    }

    public void setSourceLabel(String label) {
        this.sourceLabel = this.empty2null(label);
    }

    public void setStartArrow(ArrowType startArrow) {
        assert (startArrow != null);
        this.startArrow = startArrow;
    }

    public void setStartInclination(Point startInclination) {
        this.startInclination = startInclination;
    }

    public void setTargetLabel(String targetLabel) {
        this.targetLabel = this.empty2null(targetLabel);
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public String getLabelFontFamily() {
        return this.labelFontFamily;
    }

    public void setLabelFontFamily(String labelFontFamily) {
        this.labelFontFamily = labelFontFamily;
    }

    public int getLabelFontSize() {
        return this.labelFontSize;
    }

    public void setLabelFontSize(int labelFontSize) {
        this.labelFontSize = labelFontSize;
    }

    private String empty2null(String label) {
        return "".equals(label) ? null : label;
    }

    public void changeInclination(int deltaX, int deltaY, NodeModel linkedNodeView, Point changedInclination) {
        double k;
        if (linkedNodeView.isLeft()) {
            deltaX = -deltaX;
        }
        changedInclination.translate(deltaX, deltaY);
        if (changedInclination.x != 0 && Math.abs((double)changedInclination.y / (double)changedInclination.x) < 0.015) {
            changedInclination.y = 0;
        }
        if ((k = changedInclination.distance(0.0, 0.0)) < 10.0) {
            if (k > 0.0) {
                changedInclination.x = (int)((double)(changedInclination.x * 10) / k);
                changedInclination.y = (int)((double)(changedInclination.y * 10) / k);
            } else {
                changedInclination.x = 10;
            }
        }
    }
}

