/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.link.HyperTextLinkModel;
import org.freeplane.features.link.MapLinks;
import org.freeplane.features.link.NodeLinkModel;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;

public class NodeLinks
implements IExtension {
    public static final Object CONNECTOR = "connector";
    private URI nonLocalHyperlink;
    private Boolean formatNodeAsHyperlink;
    private final LinkedList<NodeLinkModel> links = new LinkedList();
    public static final Object HYPERLINK_CHANGED = "hyperlink_changed";

    public static NodeLinks createLinkExtension(NodeModel node) {
        NodeLinks nodeLinks = NodeLinks.getLinkExtension(node);
        if (nodeLinks != null) {
            return nodeLinks;
        }
        nodeLinks = new NodeLinks();
        node.addExtension(nodeLinks);
        return nodeLinks;
    }

    public static URI getLink(NodeModel node) {
        NodeLinks links = NodeLinks.getLinkExtension(node);
        return links != null ? links.getHyperLink(node) : null;
    }

    public static Boolean formatNodeAsHyperlink(NodeModel node) {
        NodeLinks links = NodeLinks.getLinkExtension(node);
        return links != null ? links.formatNodeAsHyperlink() : null;
    }

    public static String getLinkAsString(NodeModel selectedNode) {
        URI link = NodeLinks.getValidLink(selectedNode);
        return link != null ? link.toString() : null;
    }

    public static NodeLinks getLinkExtension(NodeModel node) {
        return node.getExtension(NodeLinks.class);
    }

    public static Collection<NodeLinkModel> getLinks(NodeModel node) {
        NodeLinks links = NodeLinks.getLinkExtension(node);
        if (links != null) {
            List<NodeLinkModel> sharedLinks = links.getLinks();
            ArrayList<NodeLinkModel> clones = new ArrayList<NodeLinkModel>(sharedLinks.size());
            for (NodeLinkModel sharedLink : sharedLinks) {
                NodeLinkModel cloneForSource = sharedLink.cloneForSource(node);
                if (cloneForSource == null) continue;
                clones.add(cloneForSource);
            }
            return clones;
        }
        return Collections.emptyList();
    }

    public void addArrowlink(NodeLinkModel newLink) {
        this.links.add(newLink);
        MapModel map = newLink.getSource().getMap();
        this.addLinkToMap(map, newLink);
    }

    private void addLinkToMap(MapModel map, NodeLinkModel newLink) {
        MapLinks mapLinks = MapLinks.getLinks(map);
        if (mapLinks == null) {
            mapLinks = new MapLinks();
            map.addExtension(mapLinks);
        }
        mapLinks.add(newLink);
    }

    public URI getHyperLink(NodeModel clone) {
        if (this.nonLocalHyperlink != null) {
            return this.nonLocalHyperlink;
        }
        for (NodeLinkModel link : this.links) {
            if (!(link instanceof HyperTextLinkModel)) continue;
            try {
                return new URI("#" + link.getTargetID());
            }
            catch (URISyntaxException e) {
                LogUtils.severe(e);
            }
        }
        return null;
    }

    public List<NodeLinkModel> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public void removeArrowlink(NodeLinkModel link) {
        NodeModel node = link.getSource();
        for (NodeLinkModel i : NodeLinks.getLinkExtension((NodeModel)node).links) {
            if (!link.equals(i.cloneForSource(link.getSource()))) continue;
            this.links.remove(i);
            MapModel map = link.getSource().getMap();
            this.removeLinkFromMap(map, i);
            return;
        }
    }

    private void removeLinkFromMap(MapModel map, NodeLinkModel link) {
        MapLinks mapLinks = MapLinks.getLinks(map);
        mapLinks.remove(link);
    }

    public String removeLocalHyperLink(NodeModel node) {
        Iterator iterator = this.links.iterator();
        while (iterator.hasNext()) {
            NodeLinkModel link = (NodeLinkModel)iterator.next();
            if (!(link instanceof HyperTextLinkModel)) continue;
            iterator.remove();
            this.removeLinkFromMap(node.getMap(), link);
            return link.getTargetID();
        }
        return null;
    }

    public void setHyperLink(URI hyperlink) {
        this.nonLocalHyperlink = hyperlink;
    }

    public void setLocalHyperlink(NodeModel node, String targetID) {
        this.nonLocalHyperlink = null;
        this.removeLocalHyperLink(node);
        if (targetID != null) {
            HyperTextLinkModel link = new HyperTextLinkModel(node, targetID);
            this.links.add(link);
            this.addLinkToMap(node.getMap(), link);
        }
    }

    public static URI getValidLink(NodeModel model) {
        URI link = NodeLinks.getLink(model);
        if (link == null) {
            return null;
        }
        String linkString = link.toString();
        if (linkString.startsWith("#")) {
            String id = linkString.substring(1);
            if (model.getMap().getNodeForID(id) == null) {
                return null;
            }
        }
        return link;
    }

    public Boolean formatNodeAsHyperlink() {
        return this.formatNodeAsHyperlink;
    }

    public void setFormatNodeAsHyperlink(Boolean formatNodeAsHyperlink) {
        this.formatNodeAsHyperlink = formatNodeAsHyperlink;
    }

    public void replaceMapLinksForDeletedSourceNode(MapLinks mapLinks, NodeModel deletionRoot, NodeModel node) {
        ListIterator<NodeLinkModel> linkIterator = this.links.listIterator();
        block0: while (linkIterator.hasNext()) {
            NodeLinkModel link = (NodeLinkModel)linkIterator.next();
            NodeModel linkSource = link.getSource();
            if (!linkSource.equals(node)) continue;
            mapLinks.remove(link);
            linkIterator.remove();
            for (NodeModel newSource : node.subtreeClones()) {
                NodeLinkModel cloneForSource;
                if (node == newSource || newSource.isDescendantOf(deletionRoot) || (cloneForSource = link.cloneForSource(newSource)) == null) continue;
                linkIterator.add(cloneForSource);
                mapLinks.add(cloneForSource);
                continue block0;
            }
        }
    }
}

