/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.freeplane.core.io.IElementDOMHandler;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.UnknownElements;
import org.freeplane.core.io.xml.TreeXmlReader;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeBuilder;
import org.freeplane.features.map.NodeModel;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.n3.nanoxml.XMLException;

public class MapReader
implements IElementDOMHandler {
    private final NodeBuilder nodeBuilder;
    private final ReadManager readManager;
    private NodeTreeCreator nodeTreeCreator;

    public NodeTreeCreator getCurrentNodeTreeCreator() {
        return this.nodeTreeCreator;
    }

    public MapReader(ReadManager readManager) {
        this.readManager = readManager;
        this.nodeBuilder = new NodeBuilder(this);
        this.nodeBuilder.registerBy(readManager);
    }

    @Override
    public Object createElement(Object parent, String tag, XMLElement attributes) {
        return this.nodeTreeCreator.getCreatedMap();
    }

    public NodeModel createNodeTreeFromXml(MapModel map, Reader pReader, MapWriter.Mode mode) throws IOException, XMLException {
        HashMap<Object, Object> hints = new HashMap<Object, Object>(1);
        hints.put((Object)MapWriter.Hint.MODE, (Object)mode);
        return this.createNodeTreeFromXml(map, pReader, hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeModel createNodeTreeFromXml(MapModel map, Reader pReader, Map<Object, Object> hints) throws IOException, XMLException {
        NodeTreeCreator oldNodeTreeCreator = this.nodeTreeCreator;
        try {
            NodeModel topNode;
            this.nodeTreeCreator = new NodeTreeCreator(hints);
            NodeModel nodeModel = topNode = this.nodeTreeCreator.createNodeTreeFromXml(map, pReader);
            return nodeModel;
        }
        finally {
            this.nodeTreeCreator = oldNodeTreeCreator;
        }
    }

    @Override
    public void endElement(Object parent, String tag, Object element, XMLElement dom) {
        MapModel map = (MapModel)element;
        if (dom.getAttributeCount() != 0 || dom.hasChildren()) {
            map.addExtension(new UnknownElements(dom));
        }
    }

    public boolean isMapLoadingInProcess() {
        return this.nodeTreeCreator != null;
    }

    public NodeTreeCreator nodeTreeCreator(MapModel map) {
        NodeTreeCreator nodeTreeCreator = new NodeTreeCreator();
        nodeTreeCreator.start(map);
        return nodeTreeCreator;
    }

    public class NodeTreeCreator {
        private MapModel createdMap;
        private final Map<Object, Object> hints;
        private NodeModel mapChild = null;
        private final Map<String, String> newIds = new HashMap<String, String>();

        public NodeTreeCreator() {
            this(new HashMap<Object, Object>());
        }

        public NodeTreeCreator(Map<Object, Object> hints) {
            this.hints = hints;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NodeModel create(Reader pReader) throws XMLException {
            NodeTreeCreator oldNodeTreeCreator = MapReader.this.nodeTreeCreator;
            TreeXmlReader reader = new TreeXmlReader(MapReader.this.readManager);
            try {
                NodeModel node;
                MapReader.this.nodeTreeCreator = this;
                reader.load(this.createdMap, pReader);
                NodeModel nodeModel = node = MapReader.this.nodeBuilder.getMapChild();
                return nodeModel;
            }
            finally {
                MapReader.this.nodeBuilder.reset();
                MapReader.this.nodeTreeCreator = oldNodeTreeCreator;
            }
        }

        public NodeModel createNodeTreeFromXml(MapModel map, Reader pReader) throws IOException, XMLException {
            this.start(map);
            NodeModel node = this.create(pReader);
            if (node == null) {
                throw new RuntimeException("corrupted map, no root node found");
            }
            this.finish(node);
            return node;
        }

        public void finish(NodeModel node) {
            NodeTreeCreator oldNodeTreeCreator = MapReader.this.nodeTreeCreator;
            try {
                MapReader.this.nodeTreeCreator = this;
                MapReader.this.readManager.readingCompleted(node, this.newIds);
                this.newIds.clear();
                this.createdMap = null;
            }
            finally {
                MapReader.this.nodeTreeCreator = oldNodeTreeCreator;
            }
        }

        void start(MapModel map) {
            this.createdMap = map;
        }

        public MapModel getCreatedMap() {
            return this.createdMap;
        }

        Object getHint(Object key) {
            return this.hints.get(key);
        }

        public void setHint(Object key, Object value) {
            this.hints.put(key, value);
        }

        public void putHints(Map<? extends Object, ? extends Object> m) {
            this.hints.putAll(m);
        }

        NodeModel getMapChild() {
            return this.mapChild;
        }

        public void setMapChild(NodeModel mapChild) {
            this.mapChild = mapChild;
            if (this.createdMap.getRootNode() == null && mapChild != null) {
                this.createdMap.setRoot(mapChild);
            }
        }

        public void substituteNodeID(String value, String realId) {
            this.newIds.put(value, realId);
        }

        public String substitutedID(String idCandicate) {
            String substitute = this.newIds.get(idCandicate);
            if (substitute != null) {
                return substitute;
            }
            return idCandicate;
        }
    }
}

