/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mode;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.SelectableAction;

public class AController {
    private final Map<String, AFreeplaneAction> actions = new HashMap<String, AFreeplaneAction>();

    public void addAction(AFreeplaneAction value) {
        String key = value.getKey();
        AFreeplaneAction old = this.getActions().put(key, value);
        if (old != null && !old.equals(value)) {
            this.getActions().put(key, old);
            throw new RuntimeException("action " + key + " already registered");
        }
        if (value.checkSelectionOnPropertyChange()) {
            ActionSelectorOnPropertyChange listener = new ActionSelectorOnPropertyChange(value);
            ResourceController.getResourceController().addPropertyChangeListener(listener);
        }
    }

    public void addActionIfNotAlreadySet(AFreeplaneAction action) {
        if (this.getAction(action.getKey()) == null) {
            this.addAction(action);
        }
    }

    public AFreeplaneAction getAction(String key) {
        return this.getActions().get(key);
    }

    protected Map<String, AFreeplaneAction> getActions() {
        return this.actions;
    }

    public Set<String> getActionKeys() {
        return this.actions.keySet();
    }

    public AFreeplaneAction removeAction(String key) {
        AFreeplaneAction action = this.getActions().remove(key);
        if (action.checkSelectionOnPropertyChange()) {
            ResourceController.getResourceController().removePropertyChangeListener(ActionSelectorOnPropertyChange.class, action);
        }
        return action;
    }

    public AFreeplaneAction removeActionIfSet(String key) {
        if (this.getAction(key) != null) {
            return this.removeAction(key);
        }
        return null;
    }

    public static interface IActionOnChange {
        public AFreeplaneAction getAction();
    }

    private static class ActionSelectorOnPropertyChange
    implements IFreeplanePropertyListener,
    IActionOnChange {
        final String propertyName;
        final AFreeplaneAction action;

        public ActionSelectorOnPropertyChange(AFreeplaneAction action) {
            this.action = action;
            this.propertyName = action.getClass().getAnnotation(SelectableAction.class).checkOnPropertyChange();
        }

        @Override
        public AFreeplaneAction getAction() {
            return this.action;
        }

        @Override
        public void propertyChanged(String propertyName, String newValue, String oldValue) {
            if (this.propertyName.equals(propertyName)) {
                this.action.setSelected();
            }
        }
    }
}

