/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodelocation;

import java.util.Collection;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.ui.LengthUnits;
import org.freeplane.core.util.Quantity;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ExclusivePropertyChain;
import org.freeplane.features.mode.IPropertyHandler;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodelocation.LocationBuilder;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;

public class LocationController
implements IExtension {
    private final ExclusivePropertyChain<Quantity<LengthUnits>, NodeModel> childGapHandlers;

    public static LocationController getController() {
        ModeController modeController = Controller.getCurrentModeController();
        return LocationController.getController(modeController);
    }

    public static LocationController getController(ModeController modeController) {
        return modeController.getExtension(LocationController.class);
    }

    public static void install(LocationController locationController) {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addExtension(LocationController.class, locationController);
    }

    public LocationController() {
        final ModeController modeController = Controller.getCurrentModeController();
        MapController mapController = modeController.getMapController();
        ReadManager readManager = mapController.getReadManager();
        WriteManager writeManager = mapController.getWriteManager();
        LocationBuilder locationBuilder = new LocationBuilder();
        locationBuilder.registerBy(readManager, writeManager);
        this.childGapHandlers = new ExclusivePropertyChain();
        this.addChildGapGetter(IPropertyHandler.STYLE, new IPropertyHandler<Quantity<LengthUnits>, NodeModel>(){

            @Override
            public Quantity<LengthUnits> getProperty(NodeModel node, Quantity<LengthUnits> currentValue) {
                MapModel map = node.getMap();
                LogicalStyleController styleController = LogicalStyleController.getController(modeController);
                Collection<IStyle> style = styleController.getStyles(node);
                Quantity returnedGap = LocationController.this.getStyleChildGap(map, style);
                return returnedGap;
            }
        });
        this.addChildGapGetter(IPropertyHandler.DEFAULT, new IPropertyHandler<Quantity<LengthUnits>, NodeModel>(){

            @Override
            public Quantity<LengthUnits> getProperty(NodeModel node, Quantity<LengthUnits> currentValue) {
                return LocationModel.DEFAULT_VGAP;
            }
        });
    }

    private IPropertyHandler<Quantity<LengthUnits>, NodeModel> addChildGapGetter(Integer key, IPropertyHandler<Quantity<LengthUnits>, NodeModel> getter) {
        return this.childGapHandlers.addGetter(key, getter);
    }

    private Quantity<LengthUnits> getStyleChildGap(MapModel map, Collection<IStyle> styleKeys) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : styleKeys) {
            Quantity<LengthUnits> vGap;
            LocationModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = styleNode.getExtension(LocationModel.class)) == null || (vGap = styleModel.getVGap()) == LocationModel.DEFAULT_VGAP) continue;
            return vGap;
        }
        return null;
    }

    public Quantity<LengthUnits> getHorizontalShift(NodeModel node) {
        return LocationModel.getModel(node).getHGap();
    }

    public Quantity<LengthUnits> getVerticalShift(NodeModel node) {
        return LocationModel.getModel(node).getShiftY();
    }

    public Quantity<LengthUnits> getMinimalDistanceBetweenChildren(NodeModel node) {
        return this.childGapHandlers.getProperty(node);
    }
}

