/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodestyle;

import java.awt.Color;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.LengthUnits;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.Quantity;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.nodestyle.ShapeConfigurationModel;

public class NodeStyleModel
implements IExtension,
Cloneable {
    private Color backgroundColor;
    private Color color;
    private String fontFamilyName = null;
    private Integer fontSize = null;
    private Boolean isBold = null;
    private Boolean isItalic = null;
    private ShapeConfigurationModel shapeConfiguration = ShapeConfigurationModel.NULL_SHAPE;
    private Boolean nodeNumbering = null;
    private String nodeFormat = null;
    private TextAlign textAlign = null;

    public static NodeStyleModel createNodeStyleModel(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        if (styleModel == null) {
            styleModel = new NodeStyleModel();
            node.addExtension(styleModel);
        }
        return styleModel;
    }

    public static Color getBackgroundColor(NodeModel node) {
        NodeStyleModel styleModel = NodeStyleModel.getModel(node);
        return styleModel == null ? null : styleModel.getBackgroundColor();
    }

    public static Color getColor(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? null : styleModel.getColor();
    }

    public static String getFontFamilyName(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? null : styleModel.getFontFamilyName();
    }

    public static Integer getFontSize(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? null : styleModel.getFontSize();
    }

    public static NodeStyleModel getModel(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel;
    }

    public static Boolean getNodeNumbering(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? null : styleModel.getNodeNumbering();
    }

    public static String getNodeFormat(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? null : styleModel.getNodeFormat();
    }

    public static Shape getShape(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? null : styleModel.getShape();
    }

    public static ShapeConfigurationModel getShapeConfiguration(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? ShapeConfigurationModel.NULL_SHAPE : styleModel.getShapeConfiguration();
    }

    public static Boolean isBold(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? null : styleModel.isBold();
    }

    public static Boolean isItalic(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? null : styleModel.isItalic();
    }

    public static TextAlign getTextAlign(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? null : styleModel.getTextAlign();
    }

    public static void setBackgroundColor(NodeModel node, Color color) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setBackgroundColor(color);
    }

    public static void setColor(NodeModel node, Color color) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setColor(color);
    }

    public static void setNodeNumbering(NodeModel node, Boolean enableNodeNumbering) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setNodeNumbering(enableNodeNumbering);
    }

    public static void setNodeFormat(NodeModel node, String nodeFormat) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setNodeFormat(nodeFormat);
    }

    public static void setShape(NodeModel node, String shape) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setShape(shape);
    }

    public static void setShape(NodeModel node, Shape shape) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setShape(shape);
    }

    public static void setShapeHorizontalMargin(NodeModel node, Quantity<LengthUnits> margin) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setShapeConfiguration(styleModel.getShapeConfiguration().withHorizontalMargin(margin));
    }

    public static void setShapeVerticalMargin(NodeModel node, Quantity<LengthUnits> margin) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setShapeConfiguration(styleModel.getShapeConfiguration().withVerticalMargin(margin));
    }

    public static void setShapeUniform(NodeModel node, boolean uniform) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setShapeConfiguration(styleModel.getShapeConfiguration().withUniform(uniform));
    }

    public static void setShapeConfiguration(NodeModel node, ShapeConfigurationModel shape) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setShapeConfiguration(shape);
    }

    public static void setTextAlign(NodeModel node, TextAlign textAlign) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setTextAlign(textAlign);
    }

    protected NodeStyleModel clone() {
        return this.copyTo(new NodeStyleModel());
    }

    public NodeStyleModel copyTo(NodeStyleModel nodeStyleModel) {
        if (this.color != null) {
            nodeStyleModel.setColor(this.color);
        }
        if (this.backgroundColor != null) {
            nodeStyleModel.setBackgroundColor(this.backgroundColor);
        }
        if (this.isBold != null) {
            nodeStyleModel.setBold(this.isBold);
        }
        if (this.fontFamilyName != null) {
            nodeStyleModel.setFontFamilyName(this.fontFamilyName);
        }
        if (this.fontSize != null) {
            nodeStyleModel.setFontSize(this.fontSize);
        }
        if (this.isItalic != null) {
            nodeStyleModel.setItalic(this.isItalic);
        }
        if (this.getShapeConfiguration() != null) {
            nodeStyleModel.setShapeConfiguration(this.getShapeConfiguration());
        }
        if (this.nodeFormat != null) {
            nodeStyleModel.setNodeFormat(this.nodeFormat);
        }
        if (this.nodeNumbering != null) {
            nodeStyleModel.setNodeNumbering(this.nodeNumbering);
        }
        if (this.textAlign != null) {
            nodeStyleModel.setTextAlign(this.textAlign);
        }
        return nodeStyleModel;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getColor() {
        return this.color;
    }

    public String getFontFamilyName() {
        return this.fontFamilyName;
    }

    public Integer getFontSize() {
        return this.fontSize;
    }

    public Boolean getNodeNumbering() {
        return this.nodeNumbering;
    }

    public String getNodeFormat() {
        return this.nodeFormat;
    }

    public Shape getShape() {
        return this.getShapeConfiguration().getShape();
    }

    public Boolean isBold() {
        return this.isBold;
    }

    public Boolean isItalic() {
        return this.isItalic;
    }

    public TextAlign getTextAlign() {
        return this.textAlign;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void setBold(Boolean isBold) {
        this.isBold = isBold;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setFontFamilyName(String fontFamilyName) {
        this.fontFamilyName = fontFamilyName;
    }

    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    public void setItalic(Boolean isItalic) {
        this.isItalic = isItalic;
    }

    public void setNodeNumbering(Boolean enableNodeNumbering) {
        this.nodeNumbering = enableNodeNumbering;
    }

    public void setNodeFormat(String nodeFormat) {
        this.nodeFormat = nodeFormat;
    }

    public void setShape(String shape) {
        try {
            this.setShapeConfiguration(this.getShapeConfiguration().withShape(shape != null ? Shape.valueOf(shape) : null));
        }
        catch (IllegalArgumentException e) {
            LogUtils.warn("unknown shape " + shape);
        }
    }

    public void setShape(Shape shape) {
        this.setShapeConfiguration(this.getShapeConfiguration().withShape(shape));
    }

    public void setTextAlign(TextAlign textAlign) {
        this.textAlign = textAlign;
    }

    public ShapeConfigurationModel getShapeConfiguration() {
        return this.shapeConfiguration;
    }

    public void setShapeConfiguration(ShapeConfigurationModel shapeConfiguration) {
        if (shapeConfiguration == null) {
            throw new RuntimeException("Null pointer as shapeConfiguration");
        }
        this.shapeConfiguration = shapeConfiguration;
    }

    public static enum TextAlign {
        DEFAULT(2),
        LEFT(2),
        RIGHT(4),
        CENTER(0);

        public final int swingConstant;

        private TextAlign(int swingConstant) {
            this.swingConstant = swingConstant;
        }
    }

    public static enum Shape {
        fork(false),
        bubble,
        oval,
        rectangle,
        wide_hexagon,
        narrow_hexagon,
        as_parent(false),
        combined;

        public final boolean hasConfiguration;

        private Shape() {
            this(true);
        }

        private Shape(boolean hasConfiguration) {
            this.hasConfiguration = hasConfiguration;
        }
    }
}

