/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.print;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JComponent;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.print.PrintController;
import org.freeplane.view.swing.map.MapView;

class Preview
extends JComponent {
    private static final int DEFAULT_PREVIEW_SIZE = 300;
    private static final double MINIMUM_ZOOM_FACTOR = 0.1;
    private static final long serialVersionUID = 1L;
    private Graphics2D imageGraphics;
    protected int index = 0;
    private BufferedImage previewPageImage = null;
    private final PrintController printController;
    private final Printable view;
    protected double zoom = 0.0;

    public Preview(PrintController printController, Printable view, Dimension size) {
        this.printController = printController;
        this.view = view;
        PageFormat format = this.getPageFormat();
        this.zoom = Math.min(size.getHeight() / format.getHeight(), size.getWidth() / format.getWidth());
        this.resize();
    }

    public void changeZoom(double zoom) {
        this.zoom = Math.max(0.1, this.zoom * zoom);
        this.resize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private PageFormat getPageFormat() {
        return this.printController.getPageFormat();
    }

    private int getPageHeight(PageFormat format) {
        return (int)(format.getHeight() * this.zoom);
    }

    public int getPageIndex() {
        return this.index;
    }

    private int getPageWidth(PageFormat format) {
        return (int)(format.getWidth() * this.zoom);
    }

    public void moveIndex(int indexStep) {
        int newIndex = this.index + indexStep;
        if (newIndex >= 0) {
            this.index = newIndex;
            this.previewPageImage = null;
        }
    }

    @Override
    public void paint(Graphics g) {
        try {
            Graphics2D g2d = (Graphics2D)g;
            PageFormat format = this.getPageFormat();
            this.paintPaper(g, format);
            if (this.previewPageImage == null) {
                this.previewPageImage = (BufferedImage)this.createImage(this.getPageWidth(format) - 1, this.getPageHeight(format) - 1);
                this.imageGraphics = this.previewPageImage.createGraphics();
                this.imageGraphics.scale(this.zoom, this.zoom);
                if (this.view instanceof MapView) {
                    ((MapView)this.view).preparePrinting();
                }
                while (1 == this.view.print(this.imageGraphics, format, this.index) && this.index > 0) {
                    --this.index;
                }
                if (this.view instanceof MapView) {
                    ((MapView)this.view).endPrinting();
                }
            }
            g2d.drawImage((Image)this.previewPageImage, 0, 0, this);
        }
        catch (PrinterException e) {
            LogUtils.severe(e);
        }
    }

    protected void paintPaper(Graphics g, PageFormat format) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getPageWidth(format), this.getPageHeight(format));
        g.setColor(Color.black);
        g.drawRect(0, 0, this.getPageWidth(format) - 1, this.getPageHeight(format) - 1);
    }

    public void resize() {
        PageFormat pageFormat = this.getPageFormat();
        int width = this.getPageWidth(pageFormat);
        int height = this.getPageHeight(pageFormat);
        this.setPreferredSize(new Dimension(width, height));
        this.previewPageImage = null;
        this.revalidate();
    }
}

