/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text;

import org.freeplane.core.io.xml.TreeXmlReader;
import org.freeplane.core.io.xml.TreeXmlWriter;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.TypeReference;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.CompareConditionAdapter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.text.NodeTextConditionController;
import org.freeplane.n3.nanoxml.XMLElement;

public class NodeTextCompareCondition
extends CompareConditionAdapter {
    static final String COMPARATION_RESULT = "COMPARATION_RESULT";
    static final String NAME = "node_compare_condition";
    static final String SUCCEED = "SUCCEED";
    static final String MATCH_APPROXIMATELY = "MATCH_APPROXIMATELY";
    static final String VALUE = "VALUE";
    static final String ITEM = "ITEM";
    private final int comparationResult;
    private final boolean succeed;
    private final String nodeItem;

    static ASelectableCondition load(XMLElement element) {
        Object value;
        String item = element.getAttribute(ITEM, "filter_node");
        String valueString = element.getAttribute(VALUE, null);
        if (valueString != null) {
            value = valueString;
        } else {
            String object = element.getAttribute("OBJECT", null);
            value = TypeReference.create(object);
        }
        boolean matchCase = TreeXmlReader.xmlToBoolean(element.getAttribute("MATCH_CASE", null));
        int compResult = Integer.parseInt(element.getAttribute(COMPARATION_RESULT, null));
        boolean succeed = TreeXmlReader.xmlToBoolean(element.getAttribute(SUCCEED, null));
        boolean matchApproximately = TreeXmlReader.xmlToBoolean(element.getAttribute(MATCH_APPROXIMATELY, null));
        return new NodeTextCompareCondition(item, value, matchCase, compResult, succeed, matchApproximately);
    }

    NodeTextCompareCondition(String nodeItem, Object value, boolean matchCase, int comparationResult, boolean succeed, boolean matchApproximately) {
        super(value, matchCase, matchApproximately);
        this.comparationResult = comparationResult;
        this.succeed = succeed;
        this.nodeItem = nodeItem;
    }

    @Override
    public boolean isEqualityCondition() {
        return this.comparationResult == 0;
    }

    @Override
    public boolean checkNode(NodeModel node) {
        Object[] content = NodeTextConditionController.getItemsForComparison(this.nodeItem, node);
        return content != null && this.checkContents(content);
    }

    private boolean checkContents(Object[] content) {
        for (Object o : content) {
            if (o == null || !this.checkContent(o)) continue;
            return true;
        }
        return false;
    }

    private boolean checkContent(Object content) {
        try {
            this.compareTo(content);
            return this.isComparisonOK() && this.succeed == (this.getComparisonResult() == this.comparationResult);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    protected String createDescription() {
        String nodeCondition = TextUtils.getText(this.nodeItem);
        return super.createDescription(nodeCondition, this.comparationResult, this.succeed);
    }

    @Override
    public void fillXML(XMLElement child) {
        super.fillXML(child);
        child.setAttribute(COMPARATION_RESULT, Integer.toString(this.comparationResult));
        child.setAttribute(SUCCEED, TreeXmlWriter.BooleanToXml(this.succeed));
        child.setAttribute(ITEM, this.nodeItem);
        child.setAttribute(MATCH_APPROXIMATELY, TreeXmlWriter.BooleanToXml(this.matchApproximately));
    }

    @Override
    protected String getName() {
        return NAME;
    }
}

