/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.time;

import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.format.FormattedDate;
import org.freeplane.features.time.TimeComboBoxEditor;
import org.freeplane.features.time.TimeCondition;
import org.freeplane.features.time.TimeConditionCreatedAfter;
import org.freeplane.features.time.TimeConditionCreatedBefore;
import org.freeplane.features.time.TimeConditionModifiedAfter;
import org.freeplane.features.time.TimeConditionModifiedBefore;
import org.freeplane.n3.nanoxml.XMLElement;

public class TimeConditionController
implements IElementaryConditionController {
    static final String FILTER_TIME = "filter_time";
    private final ComboBoxEditor editor = new TimeComboBoxEditor(true);
    private final ComboBoxModel values = new DefaultComboBoxModel();

    @Override
    public boolean canEditValues(Object property, TranslatedObject simpleCond) {
        return true;
    }

    @Override
    public boolean canHandle(Object selectedItem) {
        if (!(selectedItem instanceof TranslatedObject)) {
            return false;
        }
        TranslatedObject namedObject = (TranslatedObject)selectedItem;
        return namedObject.objectEquals(FILTER_TIME);
    }

    @Override
    public boolean canSelectValues(Object property, TranslatedObject simpleCond) {
        return true;
    }

    @Override
    public ASelectableCondition createCondition(Object selectedItem, TranslatedObject simpleCond, Object value, boolean matchCase, boolean matchApproximately) {
        return TimeCondition.create(simpleCond, (FormattedDate)value);
    }

    @Override
    public ComboBoxModel getConditionsForProperty(Object property) {
        return new DefaultComboBoxModel<Object>(this.getTimeConditionNames());
    }

    @Override
    public ListModel getFilteredProperties() {
        DefaultListModel<TranslatedObject> list = new DefaultListModel<TranslatedObject>();
        list.addElement(TextUtils.createTranslatedString(FILTER_TIME));
        return list;
    }

    public Object[] getTimeConditionNames() {
        return new TranslatedObject[]{TextUtils.createTranslatedString("filter_modified_after"), TextUtils.createTranslatedString("filter_modified_before"), TextUtils.createTranslatedString("filter_created_after"), TextUtils.createTranslatedString("filter_created_before")};
    }

    @Override
    public ComboBoxEditor getValueEditor(Object selectedProperty, TranslatedObject selectedCondition) {
        return this.editor;
    }

    @Override
    public ComboBoxModel getValuesForProperty(Object selectedItem, TranslatedObject simpleCond) {
        this.values.setSelectedItem(FormattedDate.createDefaultFormattedDate(System.currentTimeMillis(), "datetime"));
        return this.values;
    }

    @Override
    public boolean isCaseDependent(Object property, TranslatedObject simpleCond) {
        return false;
    }

    @Override
    public boolean supportsApproximateMatching(Object property, TranslatedObject simpleCond) {
        return false;
    }

    @Override
    public ASelectableCondition loadCondition(XMLElement element) {
        try {
            if (element.getName().equalsIgnoreCase("time_condition_created_before")) {
                String dateString = element.getAttribute("DATE", null);
                FormattedDate date = FormattedDate.createDefaultFormattedDate(Long.parseLong(dateString), "datetime");
                return new TimeConditionCreatedBefore(date);
            }
            if (element.getName().equalsIgnoreCase("time_condition_created_after")) {
                String dateString = element.getAttribute("DATE", null);
                FormattedDate date = FormattedDate.createDefaultFormattedDate(Long.parseLong(dateString), "datetime");
                return new TimeConditionCreatedAfter(date);
            }
            if (element.getName().equalsIgnoreCase("time_condition_modified_before")) {
                String dateString = element.getAttribute("DATE", null);
                FormattedDate date = FormattedDate.createDefaultFormattedDate(Long.parseLong(dateString), "datetime");
                return new TimeConditionModifiedBefore(date);
            }
            if (element.getName().equalsIgnoreCase("time_condition_modified_after")) {
                String dateString = element.getAttribute("DATE", null);
                FormattedDate date = FormattedDate.createDefaultFormattedDate(Long.parseLong(dateString), "datetime");
                return new TimeConditionModifiedAfter(date);
            }
        }
        catch (Exception e) {
            LogUtils.severe(e);
        }
        return null;
    }

    @Override
    public ListCellRenderer getValueRenderer(Object selectedProperty, TranslatedObject selectedCondition) {
        return null;
    }
}

