/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalFileChooserUI;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.ui.FixedBasicComboBoxEditor;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.components.ContainerComboBoxEditor;
import org.freeplane.core.ui.components.FreeplaneMenuBar;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.ClassLoaderFactory;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.format.FormattedDate;
import org.freeplane.features.format.FormattedObject;
import org.freeplane.features.format.ScannerController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.StyleTranslatedObject;
import org.freeplane.features.time.TimeComboBoxEditor;
import org.freeplane.features.ui.CloseAction;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.ui.ToggleFullScreenAction;
import org.freeplane.features.ui.ToggleMenubarAction;
import org.freeplane.features.ui.ToggleScrollbarsAction;
import org.freeplane.features.ui.ToggleToolbarAction;
import org.freeplane.features.ui.UIComponentVisibilityDispatcher;
import org.freeplane.features.ui.ViewController;

public abstract class FrameController
implements ViewController {
    protected final Controller controller;
    private final JLabel status;
    private final Map<String, Component> statusInfos;
    private final JPanel statusPanel;
    private final JComponent[] toolbarPanel;
    private final String propertyKeyPrefix;
    public static Icon textIcon;
    public static Icon numberIcon;
    public static Icon dateIcon;
    public static Icon dateTimeIcon;
    public static Icon linkIcon;
    public static Icon localLinkIcon;
    private final IMapViewManager mapViewManager;
    private final Timer statusTextCleaner;

    public FrameController(Controller controller, IMapViewManager mapViewManager, String propertyKeyPrefix) {
        this.controller = controller;
        this.mapViewManager = mapViewManager;
        ResourceController resourceController = ResourceController.getResourceController();
        if (textIcon == null) {
            textIcon = new ImageIcon(resourceController.getResource("/images/text.png"));
            numberIcon = new ImageIcon(resourceController.getResource("/images/number.png"));
            dateIcon = new ImageIcon(resourceController.getResource("/images/calendar_red.png"));
            dateTimeIcon = new ImageIcon(resourceController.getResource("/images/calendar_clock_red.png"));
            linkIcon = new ImageIcon(resourceController.getResource("/images/" + resourceController.getProperty("link_icon")));
            localLinkIcon = new ImageIcon(resourceController.getResource("/images/" + resourceController.getProperty("link_local_icon")));
        }
        this.propertyKeyPrefix = propertyKeyPrefix;
        this.statusPanel = new JPanel(new FlowLayout(0, 3, 0));
        UIComponentVisibilityDispatcher.install(this, this.statusPanel, "toolbarVisible");
        this.status = new JLabel();
        this.status.setBorder(BorderFactory.createEtchedBorder());
        this.statusPanel.add(this.status);
        this.statusInfos = new HashMap<String, Component>();
        this.statusInfos.put("standard", this.status);
        this.statusTextCleaner = new Timer(10000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameController.this.status.setText(null);
            }
        });
        this.statusTextCleaner.setRepeats(false);
        controller.setViewController(this);
        controller.addAction(new ToggleFullScreenAction(this));
        controller.addAction(new CloseAction());
        controller.addAction(new ToggleMenubarAction(this));
        controller.addAction(new ToggleScrollbarsAction(this));
        controller.addAction(new ToggleToolbarAction("ToggleToolbarAction", "/main_toolbar"));
        controller.addAction(new ToggleToolbarAction("ToggleStatusAction", "/status"));
        this.toolbarPanel = new JComponent[4];
        this.toolbarPanel[0] = new HorizontalToolbarPanel(new FlowLayout(0, 0, 0));
        this.toolbarPanel[3] = Box.createVerticalBox();
        this.toolbarPanel[1] = Box.createHorizontalBox();
        this.toolbarPanel[2] = Box.createVerticalBox();
    }

    @Override
    public void changeNoteWindowLocation() {
    }

    @Override
    public void err(String msg) {
        this.status.setText(msg);
    }

    protected Controller getController() {
        return Controller.getCurrentController();
    }

    @Override
    public abstract FreeplaneMenuBar getFreeplaneMenuBar();

    @Override
    public JComponent getStatusBar() {
        return this.statusPanel;
    }

    @Override
    public void init(Controller controller) {
        JComponent mainContentPane = this.getMainContentPane();
        mainContentPane.add((Component)this.toolbarPanel[0], "North");
        mainContentPane.add((Component)this.toolbarPanel[1], "West");
        mainContentPane.add((Component)this.toolbarPanel[2], "East");
        mainContentPane.add((Component)this.toolbarPanel[3], "South");
        this.status.setText("");
        mainContentPane.getRootPane().putClientProperty(Controller.class, controller);
    }

    private JComponent getMainContentPane() {
        return (JComponent)((RootPaneContainer)((Object)this.getMenuComponent())).getContentPane();
    }

    @Override
    public abstract void insertComponentIntoSplitPane(JComponent var1);

    @Override
    public abstract boolean isApplet();

    @Override
    public boolean isMenubarVisible() {
        return this.isComponentVisible("menubar");
    }

    @Override
    public boolean areScrollbarsVisible() {
        return this.isComponentVisible("scrollbars");
    }

    private boolean isComponentVisible(String component) {
        String property = this.isMenuComponentInFullScreenMode() ? component + "Visible.fullscreen" : component + "Visible";
        boolean booleanProperty = ResourceController.getResourceController().getBooleanProperty(this.getPropertyKeyPrefix() + property);
        return booleanProperty;
    }

    protected boolean isMenuComponentInFullScreenMode() {
        return this.isFullScreenEnabled(this.getMenuComponent());
    }

    boolean isFullScreenEnabled() {
        return this.isFullScreenEnabled(this.getCurrentRootComponent());
    }

    boolean isFullScreenEnabled(Component currentRootComponent) {
        return currentRootComponent instanceof Frame && !((Frame)currentRootComponent).isResizable();
    }

    @Override
    public abstract void openDocument(URI var1) throws IOException;

    @Override
    public abstract void openDocument(URL var1) throws Exception;

    @Override
    public void out(String msg) {
        this.status.setText(msg);
        this.statusTextCleaner.restart();
    }

    @Override
    public void addStatusInfo(String key, String info) {
        this.addStatusInfo(key, info, null, null);
    }

    @Override
    public void addStatusInfo(String key, Icon icon) {
        this.addStatusInfo(key, null, icon, null);
    }

    @Override
    public void addStatusInfo(String key, String info, Icon icon) {
        this.addStatusInfo(key, info, icon, null);
    }

    @Override
    public void addStatusInfo(String key, String info, Icon icon, String tooltip) {
        JLabel label = (JLabel)this.statusInfos.get(key);
        if (label == null) {
            label = new JLabel(info);
            label.setBorder(BorderFactory.createEtchedBorder());
            this.statusInfos.put(key, label);
            this.statusPanel.add((Component)label, this.statusPanel.getComponentCount() - 1);
        } else {
            label.setText(info);
            label.revalidate();
            label.repaint();
        }
        label.setIcon(icon);
        label.setToolTipText(tooltip);
        label.setVisible(info != null || icon != null);
    }

    @Override
    public void addStatusComponent(String key, Component component) {
        Component oldComponent = this.statusInfos.put(key, component);
        if (oldComponent == null) {
            this.statusPanel.add(component, this.statusPanel.getComponentCount() - 1);
        } else {
            int index = UITools.getComponentIndex(component);
            this.statusPanel.remove(index);
            this.statusPanel.add(component, index);
        }
    }

    @Override
    public void removeStatus(String key) {
        Component oldComponent = this.statusInfos.remove(key);
        if (oldComponent == null) {
            return;
        }
        this.statusPanel.remove(oldComponent);
    }

    @Override
    public abstract void removeSplitPane();

    @Override
    public void saveProperties() {
    }

    @Override
    public void selectMode(ModeController oldModeController, ModeController newModeController) {
        int j;
        if (oldModeController == newModeController) {
            return;
        }
        if (oldModeController != null) {
            IUserInputListenerFactory userInputListenerFactory = oldModeController.getUserInputListenerFactory();
            for (j = 0; j < 4; ++j) {
                Iterable<JComponent> modeToolBars = userInputListenerFactory.getToolBars(j);
                if (modeToolBars == null) continue;
                for (Component component : modeToolBars) {
                    this.toolbarPanel[j].remove(component);
                }
                this.toolbarPanel[j].revalidate();
            }
        }
        IUserInputListenerFactory newUserInputListenerFactory = newModeController.getUserInputListenerFactory();
        for (j = 0; j < 4; ++j) {
            Iterable<JComponent> newToolBars = newUserInputListenerFactory.getToolBars(j);
            if (newToolBars == null) continue;
            int i = 0;
            for (JComponent toolBar : newToolBars) {
                UIComponentVisibilityDispatcher dispatcher = UIComponentVisibilityDispatcher.dispatcher(toolBar);
                if (dispatcher == null) continue;
                dispatcher.resetVisible();
                this.toolbarPanel[j].add((Component)toolBar, i++);
            }
            this.toolbarPanel[j].revalidate();
            this.toolbarPanel[j].repaint();
        }
        this.setFreeplaneMenuBar(newUserInputListenerFactory.getMenuBar());
        this.setUIComponentsVisible(newModeController.getController().getMapViewManager(), this.isMenubarVisible());
    }

    private void setUIComponentsVisible(IMapViewManager iMapViewManager, boolean visible) {
        this.setMenubarVisible(visible);
    }

    protected abstract void setFreeplaneMenuBar(FreeplaneMenuBar var1);

    @Override
    public void setMenubarVisible(boolean visible) {
        this.setComponentVisibleProperty("menubar", visible);
        FreeplaneMenuBar freeplaneMenuBar = this.getFreeplaneMenuBar();
        ((Component)freeplaneMenuBar).setVisible(visible);
    }

    @Override
    public void setScrollbarsVisible(boolean visible) {
        this.setComponentVisibleProperty("scrollbars", visible);
    }

    private void setComponentVisibleProperty(String componentName, boolean visible) {
        String property = this.isMenuComponentInFullScreenMode() ? componentName + "Visible.fullscreen" : componentName + "Visible";
        ResourceController.getResourceController().setProperty(this.getPropertyKeyPrefix() + property, visible);
    }

    @Override
    public abstract void setTitle(String var1);

    @Override
    public abstract void setWaitingCursor(boolean var1);

    @Override
    public void viewNumberChanged(int number) {
    }

    protected void setFullScreen(boolean fullScreen) {
        JFrame frame = (JFrame)this.getCurrentRootComponent();
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (fullScreen == this.isFullScreenEnabled()) {
            return;
        }
        Controller controller = this.getController();
        ResourceController.getResourceController().firePropertyChanged("fullscreen_enabled", Boolean.toString(!fullScreen), Boolean.toString(fullScreen));
        Collection<Window> visibleFrames = this.collectVisibleFrames(frame);
        if (fullScreen) {
            GraphicsConfiguration graphicsConfiguration = frame.getGraphicsConfiguration();
            Rectangle bounds = graphicsConfiguration.getBounds();
            frame.getRootPane().putClientProperty(FrameState.class, new FrameState(frame.getBounds(), frame.getExtendedState()));
            frame.getExtendedState();
            frame.dispose();
            frame.setExtendedState(6);
            frame.setBounds(bounds);
            frame.setUndecorated(true);
            frame.setResizable(false);
            this.setUIComponentsVisible(controller.getMapViewManager(), this.isMenubarVisible());
            for (int j = 0; j < 4; ++j) {
                Iterable<JComponent> toolBars = controller.getModeController().getUserInputListenerFactory().getToolBars(j);
                for (JComponent toolBar : toolBars) {
                    UIComponentVisibilityDispatcher.dispatcher(toolBar).resetVisible();
                }
            }
            this.showWindows(visibleFrames);
        } else {
            frame.dispose();
            frame.setUndecorated(false);
            frame.setResizable(true);
            FrameState frameState = (FrameState)frame.getRootPane().getClientProperty(FrameState.class);
            frame.setBounds(frameState.bounds);
            frame.setExtendedState(frameState.winState);
            this.setUIComponentsVisible(controller.getMapViewManager(), this.isMenubarVisible());
            for (int j = 0; j < 4; ++j) {
                Iterable<JComponent> toolBars = controller.getModeController().getUserInputListenerFactory().getToolBars(j);
                for (JComponent toolBar : toolBars) {
                    UIComponentVisibilityDispatcher.dispatcher(toolBar).resetVisible();
                }
            }
            this.showWindows(visibleFrames);
        }
        if (focusOwner != null) {
            focusOwner.requestFocus();
        }
    }

    private Collection<Window> collectVisibleFrames(Window window) {
        if (!window.isVisible()) {
            return Collections.emptyList();
        }
        Window[] ownedWindows = window.getOwnedWindows();
        ArrayList<Window> visibleWindows = new ArrayList<Window>(ownedWindows.length + 1);
        visibleWindows.add(window);
        for (Window child : ownedWindows) {
            visibleWindows.addAll(this.collectVisibleFrames(child));
        }
        return visibleWindows;
    }

    protected void showWindows(Iterable<Window> windows) {
        for (Window child : windows) {
            child.setVisible(true);
        }
    }

    @Override
    public String completeVisiblePropertyKey(JComponent toolBar) {
        if (toolBar == null) {
            return null;
        }
        return UIComponentVisibilityDispatcher.dispatcher(toolBar).completeVisiblePropertyKey();
    }

    protected String getPropertyKeyPrefix() {
        return this.propertyKeyPrefix;
    }

    public static void setLookAndFeel(String lookAndFeel, boolean supportHidpi) {
        try {
            if (lookAndFeel.equals("default")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.LookAndFeelInfo[] lafInfos = UIManager.getInstalledLookAndFeels();
                boolean setLnF = false;
                for (UIManager.LookAndFeelInfo lafInfo : lafInfos) {
                    if (!lafInfo.getName().equalsIgnoreCase(lookAndFeel)) continue;
                    UIManager.setLookAndFeel(lafInfo.getClassName());
                    setLnF = true;
                    break;
                }
                if (!setLnF) {
                    URLClassLoader userLibClassLoader = ClassLoaderFactory.getClassLoaderForUserLib();
                    try {
                        Class<?> lookAndFeelClass = userLibClassLoader.loadClass(lookAndFeel);
                        UIManager.setLookAndFeel((LookAndFeel)lookAndFeelClass.newInstance());
                        ClassLoader uiClassLoader = lookAndFeelClass.getClassLoader();
                        if (userLibClassLoader != uiClassLoader) {
                            userLibClassLoader.close();
                        }
                        UIManager.getDefaults().put("ClassLoader", uiClassLoader);
                    }
                    catch (ClassCastException | ClassNotFoundException | InstantiationException e) {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        Controller.getCurrentController().getResourceController().setProperty("lookandfeel", "default");
                    }
                }
            }
        }
        catch (Exception ex) {
            LogUtils.warn("Error while setting Look&Feel" + lookAndFeel);
        }
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        if (supportHidpi) {
            FrameController.scaleDefaultUIFonts();
        }
        try {
            new JFileChooser();
        }
        catch (Throwable t) {
            try {
                UIManager.getLookAndFeelDefaults().put("FileChooserUI", MetalFileChooserUI.class.getName());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Color color = UIManager.getColor("control");
        if (color != null && color.getAlpha() < 255) {
            UIManager.getDefaults().put("control", Color.LIGHT_GRAY);
        }
    }

    private static void scaleDefaultUIFonts() {
        Set keySet = UIManager.getLookAndFeelDefaults().keySet();
        Object[] keys = keySet.toArray(new Object[keySet.size()]);
        UIDefaults uiDefaults = UIManager.getDefaults();
        UIDefaults lookAndFeelDefaults = UIManager.getLookAndFeel().getDefaults();
        for (Object key : keys) {
            Font font;
            if (!FrameController.isFontKey(key) || (font = uiDefaults.getFont(key)) == null) continue;
            font = UITools.scaleFontInt(font, 0.8);
            UIManager.put(key, font);
            lookAndFeelDefaults.put(key, font);
        }
    }

    private static boolean isFontKey(Object key) {
        return key != null && key.toString().toLowerCase().endsWith("font");
    }

    @Override
    public void addObjectTypeInfo(Object value) {
        if (value instanceof FormattedObject) {
            value = ((FormattedObject)value).getObject();
        }
        if (value instanceof String || value instanceof StyleTranslatedObject) {
            this.addStatusInfo("ObjectType", null, textIcon);
        } else if (value instanceof FormattedDate) {
            FormattedDate fd = (FormattedDate)value;
            if (fd.containsTime()) {
                this.addStatusInfo("ObjectType", null, dateTimeIcon);
            } else {
                this.addStatusInfo("ObjectType", null, dateIcon);
            }
        } else if (value instanceof Number) {
            this.addStatusInfo("ObjectType", null, numberIcon);
        } else if (value instanceof URI) {
            this.addStatusInfo("ObjectType", null, linkIcon);
        } else {
            this.addStatusInfo("ObjectType", null, null);
        }
    }

    public static ComboBoxEditor getTextDateTimeEditor() {
        ContainerComboBoxEditor editor = new ContainerComboBoxEditor();
        TranslatedObject keyText = new TranslatedObject("text", "1Ab");
        FixedBasicComboBoxEditor textEditor = new FixedBasicComboBoxEditor(){
            private Object oldItem;

            @Override
            public void setItem(Object object) {
                this.oldItem = object;
                if (object instanceof FormattedDate) {
                    super.setItem("");
                } else {
                    super.setItem(object);
                }
            }

            @Override
            public Object getItem() {
                Object item = super.getItem();
                Object oldItem = this.oldItem;
                this.oldItem = null;
                if (item != null && oldItem != null && item.toString().equals(oldItem.toString())) {
                    return oldItem;
                }
                if (ResourceController.getResourceController().getBooleanProperty("parse_data") && item instanceof String) {
                    Object scannedObject = ScannerController.getController().parse((String)item);
                    return scannedObject;
                }
                return item;
            }
        };
        editor.put(keyText, textEditor);
        TranslatedObject keyDate = new TranslatedObject("date", "");
        keyDate.setIcon(dateIcon);
        TimeComboBoxEditor dateComboBoxEditor = new TimeComboBoxEditor(false){

            @Override
            public void setItem(Object object) {
                if (object instanceof FormattedDate && !((FormattedDate)object).containsTime()) {
                    super.setItem(object);
                } else {
                    super.setItem(null);
                }
            }
        };
        dateComboBoxEditor.setItem();
        editor.put(keyDate, dateComboBoxEditor);
        TranslatedObject keyDateTime = new TranslatedObject("date_time", "");
        keyDateTime.setIcon(dateTimeIcon);
        TimeComboBoxEditor dateTimeComboBoxEditor = new TimeComboBoxEditor(true){

            @Override
            public void setItem(Object object) {
                if (object instanceof FormattedDate && ((FormattedDate)object).containsTime()) {
                    super.setItem(object);
                } else {
                    super.setItem(null);
                }
            }
        };
        dateTimeComboBoxEditor.setItem();
        editor.put(keyDateTime, dateTimeComboBoxEditor);
        return editor;
    }

    @Override
    public boolean quit() {
        Controller.getCurrentController().selectMode("MindMap");
        boolean allMapsClosed = Controller.getCurrentModeController().getMapController().closeAllMaps();
        if (allMapsClosed) {
            this.getController().getMapViewManager().onQuitApplication();
        }
        return allMapsClosed;
    }

    @Override
    public boolean isDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    @Override
    public void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    @Override
    public void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(runnable);
    }

    @Override
    public boolean isHeadless() {
        return false;
    }

    @Override
    public List<? extends Component> getMapViewVector() {
        return this.mapViewManager.getMapViewVector();
    }

    static class FrameState {
        final Rectangle bounds;
        final int winState;

        public FrameState(Rectangle bounds, int winState) {
            this.bounds = bounds;
            this.winState = winState;
        }
    }

    private final class HorizontalToolbarPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private HorizontalToolbarPanel(LayoutManager layout) {
            super(layout);
        }

        @Override
        public void validateTree() {
            if (!this.isValid()) {
                super.validateTree();
                this.resizeToolbarPane();
            }
        }

        private void resizeToolbarPane() {
            if (this.getWidth() == 0) {
                return;
            }
            Dimension oldPreferredSize = this.getPreferredSize();
            int maxHeight = 0;
            for (Component component : this.getComponents()) {
                if (!component.isVisible()) continue;
                maxHeight = Math.max(maxHeight, component.getY() + component.getHeight());
            }
            Dimension preferredSize = maxHeight > 0 ? new Dimension(this.getWidth(), maxHeight) : new Dimension(0, 0);
            if (oldPreferredSize.height != preferredSize.height) {
                this.setPreferredSize(preferredSize);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HorizontalToolbarPanel.this.getParent().invalidate();
                        FrameController.this.getMainContentPane().revalidate();
                    }
                });
            }
        }
    }
}

