/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.ui;

import java.awt.Component;
import java.awt.Container;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.OneTouchCollapseResizer;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.FrameController;

public class UIComponentVisibilityDispatcher {
    private static String KEY = UIComponentVisibilityDispatcher.class.getName() + ".KEY";
    private final FrameController frameController;
    private final String key;
    private final JComponent component;
    private OneTouchCollapseResizer resizer;

    public void setResizer(OneTouchCollapseResizer resizer) {
        this.resizer = resizer;
    }

    public static void install(FrameController frameController, JComponent component, String key) {
        component.putClientProperty(KEY, new UIComponentVisibilityDispatcher(frameController, component, key));
    }

    public static UIComponentVisibilityDispatcher dispatcher(JComponent component) {
        return (UIComponentVisibilityDispatcher)component.getClientProperty(KEY);
    }

    public UIComponentVisibilityDispatcher(FrameController frameController, JComponent component, String key) {
        this.frameController = frameController;
        this.component = component;
        this.key = key;
    }

    public String completeVisiblePropertyKey() {
        String completeKeyString = this.frameController.isMenuComponentInFullScreenMode() ? this.key + ".fullscreen" : this.key;
        return this.frameController.getPropertyKeyPrefix() + completeKeyString;
    }

    public void toggleVisibility() {
        ResourceController resourceController = ResourceController.getResourceController();
        boolean wasVisible = resourceController.getBooleanProperty(this.getPropertyName());
        this.setVisible(!wasVisible);
    }

    public void setVisible(boolean visible) {
        this.setProperty(visible);
        this.makeComponentVisible(visible);
        Container parent = this.component.getParent();
        if (parent != null) {
            ((JComponent)parent).revalidate();
        }
        if (!visible) {
            Component selectedComponent;
            boolean toolbarLostFocus;
            Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
            boolean bl = toolbarLostFocus = focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, this.component);
            if (toolbarLostFocus && (selectedComponent = Controller.getCurrentController().getMapViewManager().getSelectedComponent()) != null) {
                selectedComponent.requestFocus();
            }
        }
    }

    public void setProperty(boolean visible) {
        ResourceController resourceController = ResourceController.getResourceController();
        resourceController.setProperty(this.getPropertyName(), visible);
    }

    private void makeComponentVisible(boolean visible) {
        if (this.resizer == null) {
            this.component.setVisible(visible);
        } else {
            if (visible || this.frameController.isMenuComponentInFullScreenMode() && !visible) {
                this.resizer.setVisible(visible);
            }
            this.resizer.setExpanded(visible);
        }
    }

    public String getPropertyName() {
        String propertyName = this.completeVisiblePropertyKey();
        return propertyName;
    }

    public boolean isVisible() {
        String completeKeyString = this.completeVisiblePropertyKey();
        if (completeKeyString == null) {
            return true;
        }
        return !"false".equals(ResourceController.getResourceController().getProperty(completeKeyString, "true"));
    }

    public void resetVisible() {
        this.setVisible(this.isVisible());
    }
}

