/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NodeAndMapReference {
    private static final Pattern FREEPLANE_MAP_WITH_NODE_ID = Pattern.compile("\\.mm#(ID_\\d+)$", 2);
    private final String nodeReference;
    private final String mapReference;
    private final boolean hasFreeplaneFileExtension;

    public NodeAndMapReference(String nodeInMapReference) {
        Matcher matcher;
        boolean hasFreeplaneFileExtension = nodeInMapReference.toLowerCase().endsWith(".mm");
        String mapReference = nodeInMapReference;
        String nodeReference = null;
        if (!hasFreeplaneFileExtension && (matcher = FREEPLANE_MAP_WITH_NODE_ID.matcher(nodeInMapReference)).find()) {
            nodeReference = matcher.group(1);
            mapReference = nodeInMapReference.substring(0, matcher.start(1) - 1);
        }
        this.mapReference = mapReference;
        this.nodeReference = nodeReference;
        this.hasFreeplaneFileExtension = mapReference.toLowerCase().endsWith(".mm");
    }

    public boolean hasFreeplaneFileExtension() {
        return this.hasFreeplaneFileExtension;
    }

    public String getNodeReference() {
        return this.nodeReference;
    }

    public boolean hasNodeReference() {
        return this.nodeReference != null;
    }

    public String getMapReference() {
        return this.mapReference;
    }
}

