/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.filepreview;

import java.awt.Dimension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.swing.JComponent;
import org.freeplane.core.util.TextUtils;
import org.freeplane.view.swing.features.filepreview.BitmapViewerComponent;
import org.freeplane.view.swing.features.filepreview.ExternalResource;
import org.freeplane.view.swing.features.filepreview.IViewerFactory;
import org.freeplane.view.swing.features.filepreview.ScalableComponent;
import org.freeplane.view.swing.features.filepreview.ViewerLayoutManager;

public class BitmapViewerFactory
implements IViewerFactory {
    @Override
    public boolean accept(URI uri) {
        Iterator<ImageReader> readers = this.getImageReaders(uri);
        return readers.hasNext();
    }

    private Iterator<ImageReader> getImageReaders(URI uri) {
        String path = uri.getRawPath();
        int suffixPos = path.lastIndexOf(46) + 1;
        if (suffixPos == 0) {
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        String suffix = path.substring(suffixPos);
        Iterator<ImageReader> readers = ImageIO.getImageReadersBySuffix(suffix);
        return readers;
    }

    @Override
    public ScalableComponent createViewer(ExternalResource resource, URI uri, int maximumWidth) throws MalformedURLException, IOException {
        BitmapViewerComponent bitmapViewerComponent = new BitmapViewerComponent(uri);
        Dimension originalSize = bitmapViewerComponent.getOriginalSize();
        float zoom = resource.getZoom();
        if (zoom == -1.0f) {
            zoom = resource.setZoom(originalSize.width, maximumWidth);
        }
        ViewerLayoutManager viewerLayoutManager = new ViewerLayoutManager(1.0f, resource, originalSize);
        bitmapViewerComponent.setLayout(viewerLayoutManager);
        Dimension zoomedSize = viewerLayoutManager.calculatePreferredSize();
        bitmapViewerComponent.setFinalViewerSize(zoomedSize);
        return bitmapViewerComponent;
    }

    @Override
    public ScalableComponent createViewer(URI uri, Dimension preferredSize) throws MalformedURLException, IOException {
        BitmapViewerComponent bitmapViewerComponent = new BitmapViewerComponent(uri);
        bitmapViewerComponent.setFinalViewerSize(preferredSize);
        return bitmapViewerComponent;
    }

    @Override
    public String getDescription() {
        return TextUtils.getText("bitmaps");
    }

    @Override
    public ScalableComponent createViewer(URI uri, float zoom) throws MalformedURLException, IOException {
        BitmapViewerComponent bitmapViewerComponent = new BitmapViewerComponent(uri);
        bitmapViewerComponent.setFinalViewerSize(zoom);
        return bitmapViewerComponent;
    }

    @Deprecated
    public Dimension getOriginalSize(JComponent viewer) {
        return ((BitmapViewerComponent)viewer).getOriginalSize();
    }
}

