/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.filepreview;

import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.Collection;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.EnabledAction;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.view.swing.features.filepreview.ExternalResource;
import org.freeplane.view.swing.features.filepreview.ViewerController;
import org.freeplane.view.swing.features.progress.mindmapmode.ProgressUtilities;

@EnabledAction(checkOnNodeChange=true)
public class ChangeExternalImageAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public ChangeExternalImageAction() {
        super("ExternalImageChangeAction");
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        ProgressUtilities progUtil = new ProgressUtilities();
        MapController mapController = Controller.getCurrentModeController().getMapController();
        Collection<NodeModel> nodes = mapController.getSelectedNodes();
        ViewerController vc = Controller.getCurrentController().getModeController().getExtension(ViewerController.class);
        ExternalResource extRes = (ExternalResource)vc.createExtension(mapController.getSelectedNode());
        if (extRes != null) {
            URI uri = extRes.getAbsoluteUri(mapController.getSelectedNode().getMap());
            for (NodeModel node : nodes) {
                if (!progUtil.hasExternalResource(node) || progUtil.hasExtendedProgressIcon(node)) continue;
                vc.undoableDeactivateHook(node);
                vc.paste(uri, node, node.isLeft());
            }
        }
    }

    @Override
    public void setEnabled() {
        boolean enable = false;
        ProgressUtilities progUtil = new ProgressUtilities();
        Collection<NodeModel> nodes = Controller.getCurrentModeController().getMapController().getSelectedNodes();
        for (NodeModel node : nodes) {
            if (node == null || !progUtil.hasExternalResource(node) || progUtil.hasExtendedProgressIcon(node)) continue;
            enable = true;
            break;
        }
        this.setEnabled(enable);
    }
}

