/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.map.NodeView;

class ArrowIcon
implements Icon {
    private final NodeView nodeView;
    private final boolean down;
    private static final int ARROW_HEIGTH = 5;
    private static final int ARROW_HALF_WIDTH = 4;
    private static final int ICON_HEIGTH = 7;
    private static final int ICON_WIDTH = 10;

    public ArrowIcon(NodeView nodeView, boolean down) {
        this.nodeView = nodeView;
        this.down = down;
    }

    @Override
    public int getIconHeight() {
        return 7;
    }

    @Override
    public int getIconWidth() {
        return 10;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int[] xs = new int[3];
        int[] ys = new int[3];
        xs[0] = 5;
        xs[1] = 1;
        xs[2] = xs[0] + 4;
        if (this.down) {
            ys[0] = 6;
            ys[2] = 1;
            ys[1] = 1;
        } else {
            ys[0] = 1;
            ys[2] = 6;
            ys[1] = 6;
        }
        Color oldColor = g.getColor();
        Color color = this.nodeView.getEdgeColor();
        g.setColor(color);
        Graphics2D g2 = (Graphics2D)g;
        Object renderingHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        ModeController modeController = this.nodeView.getMap().getModeController();
        modeController.getController().getMapViewManager().setEdgesRenderingHint(g2);
        g.drawPolygon(xs, ys, 3);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
        g.setColor(oldColor);
    }
}

