/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import org.freeplane.view.swing.map.DrawableEllipse;
import org.freeplane.view.swing.map.MouseArea;
import org.freeplane.view.swing.map.NodeView;

class FoldingCircle
extends DrawableEllipse {
    private final boolean folded;
    private final boolean hiddenChild;

    public FoldingCircle(Color fillColor, boolean folded, boolean hiddenChild) {
        super(fillColor);
        this.folded = folded;
        this.hiddenChild = hiddenChild;
    }

    @Override
    protected void drawShape(Graphics2D g, Shape shape, Rectangle r, NodeView nodeView) {
        super.drawShape(g, shape, r, nodeView);
        if (nodeView.isRoot() & !this.folded) {
            return;
        }
        if (!nodeView.getMainView().getMouseArea().equals((Object)MouseArea.FOLDING)) {
            g.setColor(nodeView.getEdgeColor());
        } else {
            g.setColor(super.getFillColor(nodeView));
        }
        if (!this.hiddenChild) {
            g.drawLine(r.x + r.width / 4, r.y + r.height / 2, r.x + r.width * 3 / 4, r.y + r.height / 2);
        }
        if (this.folded || this.hiddenChild) {
            g.drawLine(r.x + r.width / 2, r.y + r.height / 4, r.x + r.width / 2, r.y + r.height * 3 / 4);
        }
    }

    @Override
    protected Color getFillColor(NodeView nodeView) {
        if (nodeView.getMainView().getMouseArea().equals((Object)MouseArea.FOLDING)) {
            return Color.GRAY;
        }
        return super.getFillColor(nodeView);
    }
}

