/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.features.nodestyle.ShapeConfigurationModel;
import org.freeplane.view.swing.map.VariableInsetsMainView;

class OvalMainView
extends VariableInsetsMainView {
    private static final double MARGIN_FACTOR = Math.sqrt(2.0);
    private static final long serialVersionUID = 1L;

    public OvalMainView(ShapeConfigurationModel shapeConfigurationModel) {
        super(shapeConfigurationModel);
    }

    @Override
    protected double getVerticalMarginFactor() {
        return MARGIN_FACTOR;
    }

    @Override
    protected double getHorizontalMarginFactor() {
        return MARGIN_FACTOR;
    }

    @Override
    protected void paintNodeShape(Graphics2D g) {
        g.drawOval(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    @Override
    protected void paintBackground(Graphics2D graphics, Color color) {
        graphics.setColor(color);
        graphics.fillOval(1, 1, this.getWidth() - 2, this.getHeight() - 2);
    }

    @Override
    public Point getConnectorPoint(Point p) {
        return this.getShapeConfiguration().isUniform() || !USE_COMMON_OUT_POINT_FOR_ROOT_NODE && this.getNodeView().isRoot() ? this.getConnectorPointAtTheOvalBorder(p) : super.getConnectorPoint(p);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        if (this.getShapeConfiguration().isUniform()) {
            Dimension prefSize = this.getPreferredRectangleSizeWithoutMargin(this.getMaximumWidth());
            double w = (float)prefSize.width + this.getZoom() * (float)this.getMinimumHorizontalInset();
            double h = (float)prefSize.height + this.getZoom() * (float)this.getMinimumVerticalInset();
            int diameter = (int)Math.ceil(Math.sqrt(w * w + h * h));
            prefSize.width = prefSize.height = this.limitWidth(diameter);
            return prefSize;
        }
        return super.getPreferredSize();
    }

    protected Point getConnectorPointAtTheOvalBorder(Point p) {
        double nWidth = (float)this.getWidth() / 2.0f;
        double nHeight = (float)this.getHeight() / 2.0f;
        int dx = Math.max(Math.abs(p.x - this.getWidth() / 2), this.getNodeView().getZoomed(LocationModel.DEFAULT_HGAP_PX));
        if (p.x < this.getWidth() / 2) {
            dx = -dx;
        }
        double angle = Math.atan(((double)p.y - nHeight) / (double)dx);
        if (dx < 0) {
            angle += Math.PI;
        }
        Point out = new Point((int)((1.0 + Math.cos(angle)) * nWidth), (int)((1.0 + Math.sin(angle)) * nHeight));
        return out;
    }
}

