/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.edge.SummaryEdgeView;

class SummaryEdgePainter {
    private final int[] yMins;
    private final int[] yMaxs;
    private final int[] xs;
    private int currentX;
    private int currentY1;
    private int currentY2;
    private final boolean isLeft;
    private int level;
    private int maxLevel;

    SummaryEdgePainter(NodeView parent, boolean isLeft) {
        this.isLeft = isLeft;
        int maxSize = parent.getComponentCount();
        this.xs = new int[maxSize];
        this.yMins = new int[maxSize];
        this.yMaxs = new int[maxSize];
        this.level = 0;
        this.maxLevel = 0;
        this.resetLevelValues(0);
        this.saveCurrentValues();
    }

    private void resetLevelValues(int level) {
        this.xs[level] = this.isLeft ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        this.yMins[level] = Integer.MAX_VALUE;
        this.yMaxs[level] = Integer.MIN_VALUE;
    }

    private void saveCurrentValues() {
        this.currentX = this.xs[this.level];
        this.currentY1 = this.yMins[this.level];
        this.currentY2 = this.yMaxs[this.level];
    }

    void addChild(NodeView child) {
        if (child.isLeft() != this.isLeft) {
            return;
        }
        this.setCurrentLevel(child);
        this.updateLevelValues(child);
    }

    private void updateLevelValues(NodeView child) {
        this.resetLevelValuesForStart(child);
        int spaceAround = child.getSpaceAround();
        if (child.getHeight() == 2 * spaceAround) {
            return;
        }
        int yMin = child.getY() + spaceAround;
        int yMax = child.getY() + child.getHeight() - child.getSpaceAround();
        int x = this.isLeft ? child.getX() + spaceAround : child.getX() + child.getWidth() - spaceAround;
        this.yMins[this.level] = Math.min(yMin, this.yMins[this.level]);
        this.yMaxs[this.level] = Math.max(yMax, this.yMaxs[this.level]);
        this.xs[this.level] = this.isLeft ? Math.min(x, this.xs[this.level]) : Math.max(x, this.xs[this.level]);
    }

    private void resetLevelValuesForStart(NodeView child) {
        if (child.isFirstGroupNode()) {
            this.resetLevelValues(this.level);
        }
        if (this.level > this.maxLevel) {
            this.maxLevel = this.level;
            this.resetLevelValues(this.level);
        }
    }

    private void setCurrentLevel(NodeView child) {
        if (child.isSummary()) {
            this.saveCurrentValues();
            this.resetLevelValues(this.level);
            ++this.level;
        } else {
            this.level = 0;
        }
    }

    private boolean hasSummaryEdge() {
        return this.level > 0 && this.currentY1 != Integer.MAX_VALUE;
    }

    boolean paintSummaryEdge(Graphics2D g, NodeView source, NodeView target) {
        if (!this.hasSummaryEdge()) {
            return false;
        }
        Point start1 = new Point(this.currentX, this.currentY1);
        Point start2 = new Point(this.currentX, this.currentY2);
        NodeView parentView = target.getParentView();
        UITools.convertPointToAncestor((Component)parentView, start1, source);
        UITools.convertPointToAncestor((Component)parentView, start2, source);
        SummaryEdgeView edgeView = new SummaryEdgeView(source, target, source);
        edgeView.setStart(start1);
        edgeView.paint(g);
        edgeView.setStart(start2);
        edgeView.paint(g);
        return true;
    }

    int getY1() {
        return this.currentY1;
    }

    int getY2() {
        return this.currentY2;
    }

    int getX() {
        return this.currentX;
    }
}

