/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.attribute;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.attribute.IAttributeTableModel;
import org.freeplane.features.text.HighlightedTransformedObject;
import org.freeplane.features.text.TextController;
import org.freeplane.view.swing.map.attribute.AttributeTable;

class AttributeTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    static final float ZOOM_CORRECTION_FACTOR = 0.97f;
    private boolean isPainting;
    private float zoom;
    private boolean opaque;
    private final Border defaultBorder = this.getBorder();

    @Override
    public int getHeight() {
        if (this.isPainting && this.zoom != 1.0f) {
            return (int)((float)super.getHeight() / this.zoom);
        }
        return super.getHeight();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Icon icon;
        String originalText;
        Component rendererComponent = super.getTableCellRendererComponent(table, value, hasFocus, isSelected, row, column);
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        }
        AttributeTable attributeTable = (AttributeTable)table;
        this.zoom = attributeTable.getZoom();
        IAttributeTableModel attributeTableModel = (IAttributeTableModel)((Object)table.getModel());
        String text = originalText = value == null ? null : value.toString();
        this.setBorder(this.defaultBorder);
        if (column == 1 && value != null) {
            try {
                TextController textController = TextController.getController();
                Object transformedObject = textController.getTransformedObject(value, attributeTableModel.getNode(), null);
                text = transformedObject.toString();
                if (transformedObject instanceof HighlightedTransformedObject && TextController.isMarkTransformedTextSet()) {
                    this.setBorder(BorderFactory.createLineBorder(Color.GREEN));
                }
            }
            catch (Exception e) {
                text = TextUtils.format("MainView.errorUpdateText", originalText, e.getLocalizedMessage());
                this.setBorder(BorderFactory.createLineBorder(Color.RED));
            }
            icon = value instanceof URI ? ((AttributeTable)table).getLinkIcon((URI)value) : null;
        } else {
            icon = null;
        }
        if (icon != this.getIcon()) {
            this.setIcon(icon);
        }
        this.setText(text);
        if (text != originalText) {
            String toolTip = HtmlUtils.isHtmlNode(originalText) ? text : HtmlUtils.plainToHTML(originalText);
            this.setToolTipText(toolTip);
        } else {
            int prefWidth = this.getPreferredSize().width;
            int width = table.getColumnModel().getColumn(column).getWidth();
            if (prefWidth > width) {
                String toolTip = HtmlUtils.isHtmlNode(text) ? text : HtmlUtils.plainToHTML(text);
                this.setToolTipText(toolTip);
            } else {
                this.setToolTipText(null);
            }
        }
        this.setOpaque(hasFocus);
        return rendererComponent;
    }

    @Override
    public int getWidth() {
        if (this.isPainting && this.zoom != 1.0f) {
            return (int)(0.99f + (float)super.getWidth() / this.zoom);
        }
        return super.getWidth();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.zoom != 1.0f) {
            this.zoom *= 0.97f;
            AffineTransform transform = g2.getTransform();
            g2.scale(this.zoom, this.zoom);
            this.isPainting = true;
            super.paint(g);
            this.isPainting = false;
            g2.setTransform(transform);
        } else {
            super.paint(g);
        }
    }

    @Override
    public boolean isOpaque() {
        return this.opaque;
    }

    @Override
    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
    }
}

