/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.edge;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.edge.EdgeView;
import org.freeplane.view.swing.map.link.CollisionDetector;

public class LinearEdgeView
extends EdgeView {
    public LinearEdgeView(NodeView source, NodeView target, Component paintedComponent) {
        super(source, target, paintedComponent);
    }

    @Override
    protected void draw(Graphics2D g) {
        Color color = this.getColor();
        g.setColor(color);
        Stroke stroke = this.getStroke();
        g.setStroke(stroke);
        int w = this.getWidth();
        if (w <= 1) {
            g.drawLine(this.start.x, this.start.y, this.end.x, this.end.y);
            if (this.isTargetEclipsed()) {
                g.setColor(g.getBackground());
                g.setStroke(EdgeView.getEclipsedStroke());
                g.drawLine(this.start.x, this.start.y, this.end.x, this.end.y);
                g.setColor(color);
                g.setStroke(stroke);
            }
        } else {
            Point startControlPoint = this.getControlPoint(this.getStartConnectorLocation());
            int zoomedXCTRL = w + 1;
            int xctrl = startControlPoint.x * zoomedXCTRL;
            int yctrl = startControlPoint.y * zoomedXCTRL;
            Point endControlPoint = this.getControlPoint(this.getEndConnectorLocation());
            int childXctrl = endControlPoint.x * zoomedXCTRL;
            int childYctrl = endControlPoint.y * zoomedXCTRL;
            int[] xs = new int[]{this.start.x, this.start.x + xctrl, this.end.x + childXctrl, this.end.x};
            int[] ys = new int[]{this.start.y, this.start.y + yctrl, this.end.y + childYctrl, this.end.y};
            g.drawPolyline(xs, ys, 4);
            if (this.isTargetEclipsed()) {
                g.setColor(g.getBackground());
                g.setStroke(EdgeView.getEclipsedStroke());
                g.drawPolyline(xs, ys, 4);
                g.setColor(color);
                g.setStroke(stroke);
            }
        }
    }

    @Override
    public boolean detectCollision(Point p) {
        Line2D.Float line = new Line2D.Float(this.start, this.end);
        return new CollisionDetector().detectCollision(p, line);
    }
}

