/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.link;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.link.ILinkView;

abstract class AConnectorView
implements ILinkView {
    protected final ConnectorModel connectorModel;
    protected final NodeView source;
    protected final NodeView target;

    protected double getZoom() {
        return this.getMap().getZoom();
    }

    protected int getZoomed(int i) {
        return this.getMap().getZoomed(i);
    }

    protected MapView getMap() {
        return this.source == null ? this.target.getMap() : this.source.getMap();
    }

    protected void paintArrow(Point from, Point to, Graphics2D g, double size) {
        int dx = from.x - to.x;
        int dy = from.y - to.y;
        int r2 = dx * dx + dy * dy;
        if (r2 == 0) {
            return;
        }
        double length = Math.sqrt(r2);
        double dxn = size * (double)dx / length;
        double dyn = size * (double)dy / length;
        double arrowWidth = 0.5;
        Polygon p = new Polygon();
        p.addPoint(to.x, to.y);
        p.addPoint((int)((double)to.x + dxn + 0.5 * dyn), (int)((double)to.y + dyn - 0.5 * dxn));
        p.addPoint((int)((double)to.x + dxn - 0.5 * dyn), (int)((double)to.y + dyn + 0.5 * dxn));
        p.addPoint(to.x, to.y);
        g.fillPolygon(p);
        g.drawPolygon(p);
    }

    NodeView getSource() {
        return this.source;
    }

    NodeView getTarget() {
        return this.target;
    }

    protected boolean isSourceVisible() {
        return this.source != null && this.source.isContentVisible();
    }

    protected boolean isTargetVisible() {
        return this.target != null && this.target.isContentVisible();
    }

    public AConnectorView(ConnectorModel connectorModel, NodeView source, NodeView target) {
        this.connectorModel = connectorModel;
        this.source = source;
        this.target = target;
    }
}

